/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.ArrayExtractor;
import org.jolokia.converter.json.BeanExtractor;
import org.jolokia.converter.json.CollectionExtractor;
import org.jolokia.converter.json.CompositeDataExtractor;
import org.jolokia.converter.json.DateExtractor;
import org.jolokia.converter.json.EnumExtractor;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.JsonConvertOptions;
import org.jolokia.converter.json.ListExtractor;
import org.jolokia.converter.json.MapExtractor;
import org.jolokia.converter.json.ObjectSerializationContext;
import org.jolokia.converter.json.TabularDataExtractor;
import org.jolokia.converter.json.ValueFaultHandler;
import org.jolokia.converter.object.StringToObjectConverter;
import org.jolokia.util.EscapeUtil;
import org.jolokia.util.ServiceObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectToJsonConverter {
    private List<Extractor> handlers;
    private ArrayExtractor arrayExtractor;
    private ThreadLocal<ObjectSerializationContext> stackContextLocal = new ThreadLocal();
    private StringToObjectConverter stringToObjectConverter;
    private static final String SIMPLIFIERS_DEFAULT_DEF = "META-INF/simplifiers-default";
    private static final String SIMPLIFIERS_DEF = "META-INF/simplifiers";

    public ObjectToJsonConverter(StringToObjectConverter pStringToObjectConverter, Extractor ... pSimplifyHandlers) {
        this.handlers = new ArrayList<Extractor>();
        this.handlers.add(new TabularDataExtractor());
        this.handlers.add(new CompositeDataExtractor());
        this.handlers.add(new ListExtractor());
        this.handlers.add(new MapExtractor());
        this.handlers.add(new CollectionExtractor());
        this.addSimplifiers(this.handlers, pSimplifyHandlers);
        this.handlers.add(new EnumExtractor());
        this.handlers.add(new DateExtractor());
        this.handlers.add(new BeanExtractor());
        this.arrayExtractor = new ArrayExtractor();
        this.stringToObjectConverter = pStringToObjectConverter;
    }

    public Object convertToJson(Object pValue, List<String> pPathParts, JsonConvertOptions pOptions) throws AttributeNotFoundException {
        Stack<String> extraStack = pPathParts != null ? EscapeUtil.reversePath(pPathParts) : new Stack<String>();
        return this.extractObjectWithContext(pValue, extraStack, pOptions, true);
    }

    public Object setInnerValue(Object pOuterObject, Object pNewValue, List<String> pPathParts) throws AttributeNotFoundException, IllegalAccessException, InvocationTargetException {
        String lastPathElement = pPathParts.remove(pPathParts.size() - 1);
        Stack<String> extraStack = EscapeUtil.reversePath(pPathParts);
        Object inner = this.extractObjectWithContext(pOuterObject, extraStack, JsonConvertOptions.DEFAULT, false);
        return this.setObjectValue(inner, lastPathElement, pNewValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractObject(Object pValue, Stack<String> pExtraArgs, boolean pJsonify) throws AttributeNotFoundException {
        Stack<String> pathStack;
        ObjectSerializationContext stackContext = this.stackContextLocal.get();
        String limitReached = this.checkForLimits(pValue, stackContext);
        Stack<String> stack = pathStack = pExtraArgs != null ? pExtraArgs : new Stack<String>();
        if (limitReached != null) {
            return limitReached;
        }
        try {
            stackContext.push(pValue);
            if (pValue == null) {
                Object var7_7 = null;
                return var7_7;
            }
            if (pValue.getClass().isArray()) {
                Object object = this.arrayExtractor.extractObject(this, pValue, pathStack, pJsonify);
                return object;
            }
            Object object = this.callHandler(pValue, pathStack, pJsonify);
            return object;
        }
        finally {
            stackContext.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object extractObjectWithContext(Object pValue, Stack<String> pExtraArgs, JsonConvertOptions pOpts, boolean pJsonify) throws AttributeNotFoundException {
        Object jsonResult;
        this.setupContext(pOpts);
        try {
            jsonResult = this.extractObject(pValue, pExtraArgs, pJsonify);
        }
        finally {
            this.clearContext();
        }
        return jsonResult;
    }

    private Object setObjectValue(Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = pInner.getClass();
        if (clazz.isArray()) {
            return this.arrayExtractor.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        Extractor handler = this.getExtractor(clazz);
        if (handler != null) {
            return handler.setObjectValue(this.stringToObjectConverter, pInner, pAttribute, pValue);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + clazz + " for setting object value." + " (object: " + pInner + ", attribute: " + pAttribute + ", value: " + pValue + ")");
    }

    int getCollectionLength(int originalLength) {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getCollectionSizeTruncated(originalLength);
    }

    public ValueFaultHandler getValueFaultHandler() {
        ObjectSerializationContext ctx = this.stackContextLocal.get();
        return ctx.getValueFaultHandler();
    }

    void clearContext() {
        this.stackContextLocal.remove();
    }

    void setupContext() {
        this.setupContext(new JsonConvertOptions.Builder().build());
    }

    void setupContext(JsonConvertOptions pOpts) {
        ObjectSerializationContext stackContext = new ObjectSerializationContext(pOpts);
        this.stackContextLocal.set(stackContext);
    }

    private Extractor getExtractor(Class pClazz) {
        for (Extractor handler : this.handlers) {
            if (!handler.canSetValue() || handler.getType() == null || !handler.getType().isAssignableFrom(pClazz)) continue;
            return handler;
        }
        return null;
    }

    private String checkForLimits(Object pValue, ObjectSerializationContext pStackContext) {
        if (pValue != null) {
            if (pStackContext.maxDepthReached()) {
                return pValue.toString();
            }
            if (pStackContext.alreadyVisited(pValue)) {
                return "[Reference " + pValue.getClass().getName() + "@" + Integer.toHexString(pValue.hashCode()) + "]";
            }
        }
        if (pStackContext.maxObjectsExceeded()) {
            return "[Object limit exceeded]";
        }
        return null;
    }

    private Object callHandler(Object pValue, Stack<String> pExtraArgs, boolean pJsonify) throws AttributeNotFoundException {
        Class<?> pClazz = pValue.getClass();
        for (Extractor handler : this.handlers) {
            if (handler.getType() == null || !handler.getType().isAssignableFrom(pClazz)) continue;
            return handler.extractObject(this, pValue, pExtraArgs, pJsonify);
        }
        throw new IllegalStateException("Internal error: No handler found for class " + pClazz + " (object: " + pValue + ", extraArgs: " + pExtraArgs + ")");
    }

    ThreadLocal<ObjectSerializationContext> getStackContextLocal() {
        return this.stackContextLocal;
    }

    private void addSimplifiers(List<Extractor> pHandlers, Extractor[] pSimplifyHandlers) {
        if (pSimplifyHandlers != null && pSimplifyHandlers.length > 0) {
            pHandlers.addAll(Arrays.asList(pSimplifyHandlers));
        } else {
            pHandlers.addAll(ServiceObjectFactory.createServiceObjects(SIMPLIFIERS_DEFAULT_DEF, SIMPLIFIERS_DEF));
        }
    }
}

