/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.RouteIngress;
import io.fabric8.openshift.api.model.RouteIngressFluent;
import io.fabric8.openshift.api.model.RouteIngressFluentImpl;

public class RouteIngressBuilder
extends RouteIngressFluentImpl<RouteIngressBuilder>
implements VisitableBuilder<RouteIngress, RouteIngressBuilder> {
    RouteIngressFluent<?> fluent;
    Boolean validationEnabled;

    public RouteIngressBuilder() {
        this(false);
    }

    public RouteIngressBuilder(Boolean validationEnabled) {
        this(new RouteIngress(), validationEnabled);
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteIngress(), validationEnabled);
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent, RouteIngress instance) {
        this(fluent, instance, false);
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent, RouteIngress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withHost(instance.getHost());
        fluent.withRouterCanonicalHostname(instance.getRouterCanonicalHostname());
        fluent.withRouterName(instance.getRouterName());
        fluent.withWildcardPolicy(instance.getWildcardPolicy());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public RouteIngressBuilder(RouteIngress instance) {
        this(instance, (Boolean)false);
    }

    public RouteIngressBuilder(RouteIngress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withHost(instance.getHost());
        this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname());
        this.withRouterName(instance.getRouterName());
        this.withWildcardPolicy(instance.getWildcardPolicy());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public RouteIngress build() {
        RouteIngress buildable = new RouteIngress(this.fluent.getConditions(), this.fluent.getHost(), this.fluent.getRouterCanonicalHostname(), this.fluent.getRouterName(), this.fluent.getWildcardPolicy());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

