package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UserOAuthAccessTokenListBuilder extends UserOAuthAccessTokenListFluentImpl<UserOAuthAccessTokenListBuilder> implements VisitableBuilder<UserOAuthAccessTokenList,UserOAuthAccessTokenListBuilder>{
  public UserOAuthAccessTokenListBuilder() {
    this(false);
  }
  public UserOAuthAccessTokenListBuilder(Boolean validationEnabled) {
    this(new UserOAuthAccessTokenList(), validationEnabled);
  }
  public UserOAuthAccessTokenListBuilder(UserOAuthAccessTokenListFluent<?> fluent) {
    this(fluent, false);
  }
  public UserOAuthAccessTokenListBuilder(UserOAuthAccessTokenListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UserOAuthAccessTokenList(), validationEnabled);
  }
  public UserOAuthAccessTokenListBuilder(UserOAuthAccessTokenListFluent<?> fluent,UserOAuthAccessTokenList instance) {
    this(fluent, instance, false);
  }
  public UserOAuthAccessTokenListBuilder(UserOAuthAccessTokenListFluent<?> fluent,UserOAuthAccessTokenList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UserOAuthAccessTokenListBuilder(UserOAuthAccessTokenList instance) {
    this(instance,false);
  }
  public UserOAuthAccessTokenListBuilder(UserOAuthAccessTokenList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  UserOAuthAccessTokenListFluent<?> fluent;
  Boolean validationEnabled;
  public UserOAuthAccessTokenList build() {
    UserOAuthAccessTokenList buildable = new UserOAuthAccessTokenList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}