package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RouteSpecFluentImpl<A extends RouteSpecFluent<A>> extends BaseFluent<A> implements RouteSpecFluent<A>{
  public RouteSpecFluentImpl() {
  }
  public RouteSpecFluentImpl(RouteSpec instance) {
    this.withAlternateBackends(instance.getAlternateBackends()); 
    this.withHost(instance.getHost()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withSubdomain(instance.getSubdomain()); 
    this.withTls(instance.getTls()); 
    this.withTo(instance.getTo()); 
    this.withWildcardPolicy(instance.getWildcardPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<RouteTargetReferenceBuilder> alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();
  private String host;
  private String path;
  private RoutePortBuilder port;
  private String subdomain;
  private TLSConfigBuilder tls;
  private RouteTargetReferenceBuilder to;
  private String wildcardPolicy;
  private Map<String,Object> additionalProperties;
  public A addToAlternateBackends(Integer index,RouteTargetReference item) {
    if (this.alternateBackends == null) {this.alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();}
    RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.get("alternateBackends").add(index >= 0 ? index : _visitables.get("alternateBackends").size(), builder);this.alternateBackends.add(index >= 0 ? index : alternateBackends.size(), builder); return (A)this;
  }
  public A setToAlternateBackends(Integer index,RouteTargetReference item) {
    if (this.alternateBackends == null) {this.alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();}
    RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("alternateBackends").size()) { _visitables.get("alternateBackends").add(builder); } else { _visitables.get("alternateBackends").set(index, builder);}
    if (index < 0 || index >= alternateBackends.size()) { alternateBackends.add(builder); } else { alternateBackends.set(index, builder);}
     return (A)this;
  }
  public A addToAlternateBackends(io.fabric8.openshift.api.model.RouteTargetReference... items) {
    if (this.alternateBackends == null) {this.alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();}
    for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.get("alternateBackends").add(builder);this.alternateBackends.add(builder);} return (A)this;
  }
  public A addAllToAlternateBackends(Collection<RouteTargetReference> items) {
    if (this.alternateBackends == null) {this.alternateBackends = new ArrayList<RouteTargetReferenceBuilder>();}
    for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.get("alternateBackends").add(builder);this.alternateBackends.add(builder);} return (A)this;
  }
  public A removeFromAlternateBackends(io.fabric8.openshift.api.model.RouteTargetReference... items) {
    for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.get("alternateBackends").remove(builder);if (this.alternateBackends != null) {this.alternateBackends.remove(builder);}} return (A)this;
  }
  public A removeAllFromAlternateBackends(Collection<RouteTargetReference> items) {
    for (RouteTargetReference item : items) {RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);_visitables.get("alternateBackends").remove(builder);if (this.alternateBackends != null) {this.alternateBackends.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAlternateBackends(Predicate<RouteTargetReferenceBuilder> predicate) {
    if (alternateBackends == null) return (A) this;
    final Iterator<RouteTargetReferenceBuilder> each = alternateBackends.iterator();
    final List visitables = _visitables.get("alternateBackends");
    while (each.hasNext()) {
      RouteTargetReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAlternateBackends instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RouteTargetReference> getAlternateBackends() {
    return alternateBackends != null ? build(alternateBackends) : null;
  }
  public List<RouteTargetReference> buildAlternateBackends() {
    return alternateBackends != null ? build(alternateBackends) : null;
  }
  public RouteTargetReference buildAlternateBackend(Integer index) {
    return this.alternateBackends.get(index).build();
  }
  public RouteTargetReference buildFirstAlternateBackend() {
    return this.alternateBackends.get(0).build();
  }
  public RouteTargetReference buildLastAlternateBackend() {
    return this.alternateBackends.get(alternateBackends.size() - 1).build();
  }
  public RouteTargetReference buildMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
    for (RouteTargetReferenceBuilder item: alternateBackends) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
    for (RouteTargetReferenceBuilder item: alternateBackends) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAlternateBackends(List<RouteTargetReference> alternateBackends) {
    if (this.alternateBackends != null) { _visitables.get("alternateBackends").removeAll(this.alternateBackends);}
    if (alternateBackends != null) {this.alternateBackends = new ArrayList(); for (RouteTargetReference item : alternateBackends){this.addToAlternateBackends(item);}} else { this.alternateBackends = null;} return (A) this;
  }
  public A withAlternateBackends(io.fabric8.openshift.api.model.RouteTargetReference... alternateBackends) {
    if (this.alternateBackends != null) {this.alternateBackends.clear();}
    if (alternateBackends != null) {for (RouteTargetReference item :alternateBackends){ this.addToAlternateBackends(item);}} return (A) this;
  }
  public Boolean hasAlternateBackends() {
    return alternateBackends != null && !alternateBackends.isEmpty();
  }
  public A addNewAlternateBackend(String kind,String name,Integer weight) {
    return (A)addToAlternateBackends(new RouteTargetReference(kind, name, weight));
  }
  public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackend() {
    return new RouteSpecFluentImpl.AlternateBackendsNestedImpl();
  }
  public RouteSpecFluent.AlternateBackendsNested<A> addNewAlternateBackendLike(RouteTargetReference item) {
    return new RouteSpecFluentImpl.AlternateBackendsNestedImpl(-1, item);
  }
  public RouteSpecFluent.AlternateBackendsNested<A> setNewAlternateBackendLike(Integer index,RouteTargetReference item) {
    return new RouteSpecFluentImpl.AlternateBackendsNestedImpl(index, item);
  }
  public RouteSpecFluent.AlternateBackendsNested<A> editAlternateBackend(Integer index) {
    if (alternateBackends.size() <= index) throw new RuntimeException("Can't edit alternateBackends. Index exceeds size.");
    return setNewAlternateBackendLike(index, buildAlternateBackend(index));
  }
  public RouteSpecFluent.AlternateBackendsNested<A> editFirstAlternateBackend() {
    if (alternateBackends.size() == 0) throw new RuntimeException("Can't edit first alternateBackends. The list is empty.");
    return setNewAlternateBackendLike(0, buildAlternateBackend(0));
  }
  public RouteSpecFluent.AlternateBackendsNested<A> editLastAlternateBackend() {
    int index = alternateBackends.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last alternateBackends. The list is empty.");
    return setNewAlternateBackendLike(index, buildAlternateBackend(index));
  }
  public RouteSpecFluent.AlternateBackendsNested<A> editMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<alternateBackends.size();i++) { 
    if (predicate.test(alternateBackends.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching alternateBackends. No match found.");
    return setNewAlternateBackendLike(index, buildAlternateBackend(index));
  }
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public RoutePort getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public RoutePort buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(RoutePort port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new RoutePortBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public RouteSpecFluent.PortNested<A> withNewPort() {
    return new RouteSpecFluentImpl.PortNestedImpl();
  }
  public RouteSpecFluent.PortNested<A> withNewPortLike(RoutePort item) {
    return new RouteSpecFluentImpl.PortNestedImpl(item);
  }
  public RouteSpecFluent.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public RouteSpecFluent.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new RoutePortBuilder().build());
  }
  public RouteSpecFluent.PortNested<A> editOrNewPortLike(RoutePort item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  public String getSubdomain() {
    return this.subdomain;
  }
  public A withSubdomain(String subdomain) {
    this.subdomain=subdomain; return (A) this;
  }
  public Boolean hasSubdomain() {
    return this.subdomain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTls instead.
   * @return The buildable object.
   */
  @Deprecated
  public TLSConfig getTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public TLSConfig buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(TLSConfig tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new TLSConfigBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public Boolean hasTls() {
    return this.tls != null;
  }
  public RouteSpecFluent.TlsNested<A> withNewTls() {
    return new RouteSpecFluentImpl.TlsNestedImpl();
  }
  public RouteSpecFluent.TlsNested<A> withNewTlsLike(TLSConfig item) {
    return new RouteSpecFluentImpl.TlsNestedImpl(item);
  }
  public RouteSpecFluent.TlsNested<A> editTls() {
    return withNewTlsLike(getTls());
  }
  public RouteSpecFluent.TlsNested<A> editOrNewTls() {
    return withNewTlsLike(getTls() != null ? getTls(): new TLSConfigBuilder().build());
  }
  public RouteSpecFluent.TlsNested<A> editOrNewTlsLike(TLSConfig item) {
    return withNewTlsLike(getTls() != null ? getTls(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTo instead.
   * @return The buildable object.
   */
  @Deprecated
  public RouteTargetReference getTo() {
    return this.to!=null ?this.to.build():null;
  }
  public RouteTargetReference buildTo() {
    return this.to!=null ?this.to.build():null;
  }
  public A withTo(RouteTargetReference to) {
    _visitables.get("to").remove(this.to);
    if (to!=null){ this.to= new RouteTargetReferenceBuilder(to); _visitables.get("to").add(this.to);} else { this.to = null; _visitables.get("to").remove(this.to); } return (A) this;
  }
  public Boolean hasTo() {
    return this.to != null;
  }
  public A withNewTo(String kind,String name,Integer weight) {
    return (A)withTo(new RouteTargetReference(kind, name, weight));
  }
  public RouteSpecFluent.ToNested<A> withNewTo() {
    return new RouteSpecFluentImpl.ToNestedImpl();
  }
  public RouteSpecFluent.ToNested<A> withNewToLike(RouteTargetReference item) {
    return new RouteSpecFluentImpl.ToNestedImpl(item);
  }
  public RouteSpecFluent.ToNested<A> editTo() {
    return withNewToLike(getTo());
  }
  public RouteSpecFluent.ToNested<A> editOrNewTo() {
    return withNewToLike(getTo() != null ? getTo(): new RouteTargetReferenceBuilder().build());
  }
  public RouteSpecFluent.ToNested<A> editOrNewToLike(RouteTargetReference item) {
    return withNewToLike(getTo() != null ? getTo(): item);
  }
  public String getWildcardPolicy() {
    return this.wildcardPolicy;
  }
  public A withWildcardPolicy(String wildcardPolicy) {
    this.wildcardPolicy=wildcardPolicy; return (A) this;
  }
  public Boolean hasWildcardPolicy() {
    return this.wildcardPolicy != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RouteSpecFluentImpl that = (RouteSpecFluentImpl) o;
    if (alternateBackends != null ? !alternateBackends.equals(that.alternateBackends) :that.alternateBackends != null) return false;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (subdomain != null ? !subdomain.equals(that.subdomain) :that.subdomain != null) return false;
    if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
    if (to != null ? !to.equals(that.to) :that.to != null) return false;
    if (wildcardPolicy != null ? !wildcardPolicy.equals(that.wildcardPolicy) :that.wildcardPolicy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(alternateBackends,  host,  path,  port,  subdomain,  tls,  to,  wildcardPolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (alternateBackends != null && !alternateBackends.isEmpty()) { sb.append("alternateBackends:"); sb.append(alternateBackends + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (subdomain != null) { sb.append("subdomain:"); sb.append(subdomain + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (to != null) { sb.append("to:"); sb.append(to + ","); }
    if (wildcardPolicy != null) { sb.append("wildcardPolicy:"); sb.append(wildcardPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AlternateBackendsNestedImpl<N> extends RouteTargetReferenceFluentImpl<RouteSpecFluent.AlternateBackendsNested<N>> implements RouteSpecFluent.AlternateBackendsNested<N>,Nested<N>{
    AlternateBackendsNestedImpl(Integer index,RouteTargetReference item) {
      this.index = index;
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    AlternateBackendsNestedImpl() {
      this.index = -1;
      this.builder = new RouteTargetReferenceBuilder(this);
    }
    RouteTargetReferenceBuilder builder;
    Integer index;
    public N and() {
      return (N) RouteSpecFluentImpl.this.setToAlternateBackends(index,builder.build());
    }
    public N endAlternateBackend() {
      return and();
    }
    
  }
  class PortNestedImpl<N> extends RoutePortFluentImpl<RouteSpecFluent.PortNested<N>> implements RouteSpecFluent.PortNested<N>,Nested<N>{
    PortNestedImpl(RoutePort item) {
      this.builder = new RoutePortBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new RoutePortBuilder(this);
    }
    RoutePortBuilder builder;
    public N and() {
      return (N) RouteSpecFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class TlsNestedImpl<N> extends TLSConfigFluentImpl<RouteSpecFluent.TlsNested<N>> implements RouteSpecFluent.TlsNested<N>,Nested<N>{
    TlsNestedImpl(TLSConfig item) {
      this.builder = new TLSConfigBuilder(this, item);
    }
    TlsNestedImpl() {
      this.builder = new TLSConfigBuilder(this);
    }
    TLSConfigBuilder builder;
    public N and() {
      return (N) RouteSpecFluentImpl.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  class ToNestedImpl<N> extends RouteTargetReferenceFluentImpl<RouteSpecFluent.ToNested<N>> implements RouteSpecFluent.ToNested<N>,Nested<N>{
    ToNestedImpl(RouteTargetReference item) {
      this.builder = new RouteTargetReferenceBuilder(this, item);
    }
    ToNestedImpl() {
      this.builder = new RouteTargetReferenceBuilder(this);
    }
    RouteTargetReferenceBuilder builder;
    public N and() {
      return (N) RouteSpecFluentImpl.this.withTo(builder.build());
    }
    public N endTo() {
      return and();
    }
    
  }
  
}