package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RouteIngressFluentImpl<A extends RouteIngressFluent<A>> extends BaseFluent<A> implements RouteIngressFluent<A>{
  public RouteIngressFluentImpl() {
  }
  public RouteIngressFluentImpl(RouteIngress instance) {
    this.withConditions(instance.getConditions()); 
    this.withHost(instance.getHost()); 
    this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname()); 
    this.withRouterName(instance.getRouterName()); 
    this.withWildcardPolicy(instance.getWildcardPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<RouteIngressConditionBuilder> conditions = new ArrayList<RouteIngressConditionBuilder>();
  private String host;
  private String routerCanonicalHostname;
  private String routerName;
  private String wildcardPolicy;
  private Map<String,Object> additionalProperties;
  public A addToConditions(Integer index,RouteIngressCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<RouteIngressConditionBuilder>();}
    RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,RouteIngressCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<RouteIngressConditionBuilder>();}
    RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.RouteIngressCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<RouteIngressConditionBuilder>();}
    for (RouteIngressCondition item : items) {RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<RouteIngressCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<RouteIngressConditionBuilder>();}
    for (RouteIngressCondition item : items) {RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.RouteIngressCondition... items) {
    for (RouteIngressCondition item : items) {RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<RouteIngressCondition> items) {
    for (RouteIngressCondition item : items) {RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<RouteIngressConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<RouteIngressConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      RouteIngressConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RouteIngressCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<RouteIngressCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public RouteIngressCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public RouteIngressCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public RouteIngressCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public RouteIngressCondition buildMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
    for (RouteIngressConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
    for (RouteIngressConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<RouteIngressCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (RouteIngressCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.RouteIngressCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (RouteIngressCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
  }
  public RouteIngressFluent.ConditionsNested<A> addNewCondition() {
    return new RouteIngressFluentImpl.ConditionsNestedImpl();
  }
  public RouteIngressFluent.ConditionsNested<A> addNewConditionLike(RouteIngressCondition item) {
    return new RouteIngressFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public RouteIngressFluent.ConditionsNested<A> setNewConditionLike(Integer index,RouteIngressCondition item) {
    return new RouteIngressFluentImpl.ConditionsNestedImpl(index, item);
  }
  public RouteIngressFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public RouteIngressFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public RouteIngressFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public RouteIngressFluent.ConditionsNested<A> editMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  public String getRouterCanonicalHostname() {
    return this.routerCanonicalHostname;
  }
  public A withRouterCanonicalHostname(String routerCanonicalHostname) {
    this.routerCanonicalHostname=routerCanonicalHostname; return (A) this;
  }
  public Boolean hasRouterCanonicalHostname() {
    return this.routerCanonicalHostname != null;
  }
  public String getRouterName() {
    return this.routerName;
  }
  public A withRouterName(String routerName) {
    this.routerName=routerName; return (A) this;
  }
  public Boolean hasRouterName() {
    return this.routerName != null;
  }
  public String getWildcardPolicy() {
    return this.wildcardPolicy;
  }
  public A withWildcardPolicy(String wildcardPolicy) {
    this.wildcardPolicy=wildcardPolicy; return (A) this;
  }
  public Boolean hasWildcardPolicy() {
    return this.wildcardPolicy != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RouteIngressFluentImpl that = (RouteIngressFluentImpl) o;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (routerCanonicalHostname != null ? !routerCanonicalHostname.equals(that.routerCanonicalHostname) :that.routerCanonicalHostname != null) return false;
    if (routerName != null ? !routerName.equals(that.routerName) :that.routerName != null) return false;
    if (wildcardPolicy != null ? !wildcardPolicy.equals(that.wildcardPolicy) :that.wildcardPolicy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  host,  routerCanonicalHostname,  routerName,  wildcardPolicy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (routerCanonicalHostname != null) { sb.append("routerCanonicalHostname:"); sb.append(routerCanonicalHostname + ","); }
    if (routerName != null) { sb.append("routerName:"); sb.append(routerName + ","); }
    if (wildcardPolicy != null) { sb.append("wildcardPolicy:"); sb.append(wildcardPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends RouteIngressConditionFluentImpl<RouteIngressFluent.ConditionsNested<N>> implements RouteIngressFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,RouteIngressCondition item) {
      this.index = index;
      this.builder = new RouteIngressConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new RouteIngressConditionBuilder(this);
    }
    RouteIngressConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) RouteIngressFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}