package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ResourceAccessReviewResponseFluentImpl<A extends ResourceAccessReviewResponseFluent<A>> extends BaseFluent<A> implements ResourceAccessReviewResponseFluent<A>{
  public ResourceAccessReviewResponseFluentImpl() {
  }
  public ResourceAccessReviewResponseFluentImpl(ResourceAccessReviewResponse instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withEvalutionError(instance.getEvalutionError()); 
    this.withGroups(instance.getGroups()); 
    this.withKind(instance.getKind()); 
    this.withNamespace(instance.getNamespace()); 
    this.withUsers(instance.getUsers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String evalutionError;
  private List<String> groups = new ArrayList<String>();
  private String kind;
  private String namespace;
  private List<String> users = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getEvalutionError() {
    return this.evalutionError;
  }
  public A withEvalutionError(String evalutionError) {
    this.evalutionError=evalutionError; return (A) this;
  }
  public Boolean hasEvalutionError() {
    return this.evalutionError != null;
  }
  public A addToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(Integer index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<String> items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public List<String> getGroups() {
    return this.groups;
  }
  public String getGroup(Integer index) {
    return this.groups.get(index);
  }
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear();}
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public A addToUsers(Integer index,String item) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    this.users.add(index, item);
    return (A)this;
  }
  public A setToUsers(Integer index,String item) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    this.users.set(index, item); return (A)this;
  }
  public A addToUsers(java.lang.String... items) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    for (String item : items) {this.users.add(item);} return (A)this;
  }
  public A addAllToUsers(Collection<String> items) {
    if (this.users == null) {this.users = new ArrayList<String>();}
    for (String item : items) {this.users.add(item);} return (A)this;
  }
  public A removeFromUsers(java.lang.String... items) {
    for (String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
  }
  public A removeAllFromUsers(Collection<String> items) {
    for (String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
  }
  public List<String> getUsers() {
    return this.users;
  }
  public String getUser(Integer index) {
    return this.users.get(index);
  }
  public String getFirstUser() {
    return this.users.get(0);
  }
  public String getLastUser() {
    return this.users.get(users.size() - 1);
  }
  public String getMatchingUser(Predicate<String> predicate) {
    for (String item: users) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUser(Predicate<String> predicate) {
    for (String item: users) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsers(List<String> users) {
    if (users != null) {this.users = new ArrayList(); for (String item : users){this.addToUsers(item);}} else { this.users = null;} return (A) this;
  }
  public A withUsers(java.lang.String... users) {
    if (this.users != null) {this.users.clear();}
    if (users != null) {for (String item :users){ this.addToUsers(item);}} return (A) this;
  }
  public Boolean hasUsers() {
    return users != null && !users.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResourceAccessReviewResponseFluentImpl that = (ResourceAccessReviewResponseFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (evalutionError != null ? !evalutionError.equals(that.evalutionError) :that.evalutionError != null) return false;
    if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (users != null ? !users.equals(that.users) :that.users != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  evalutionError,  groups,  kind,  namespace,  users,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (evalutionError != null) { sb.append("evalutionError:"); sb.append(evalutionError + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (users != null && !users.isEmpty()) { sb.append("users:"); sb.append(users + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}