package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.util.function.Predicate;
import java.util.List;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.LinkedHashMap;
import java.util.Collection;
import io.fabric8.kubernetes.api.builder.Nested;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PolicyRuleFluentImpl<A extends PolicyRuleFluent<A>> extends BaseFluent<A> implements PolicyRuleFluent<A>{
  public PolicyRuleFluentImpl() {
  }
  public PolicyRuleFluentImpl(PolicyRule instance) {
    this.withApiGroups(instance.getApiGroups()); 
    this.withAttributeRestrictions(instance.getAttributeRestrictions()); 
    this.withNonResourceURLs(instance.getNonResourceURLs()); 
    this.withResourceNames(instance.getResourceNames()); 
    this.withResources(instance.getResources()); 
    this.withVerbs(instance.getVerbs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> apiGroups = new ArrayList<String>();
  private VisitableBuilder<? extends HasMetadata,?> attributeRestrictions;
  private List<String> nonResourceURLs = new ArrayList<String>();
  private List<String> resourceNames = new ArrayList<String>();
  private List<String> resources = new ArrayList<String>();
  private List<String> verbs = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  public A addToApiGroups(Integer index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.add(index, item);
    return (A)this;
  }
  public A setToApiGroups(Integer index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.set(index, item); return (A)this;
  }
  public A addToApiGroups(java.lang.String... items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A addAllToApiGroups(Collection<String> items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A removeFromApiGroups(java.lang.String... items) {
    for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public A removeAllFromApiGroups(Collection<String> items) {
    for (String item : items) {if (this.apiGroups!= null){ this.apiGroups.remove(item);}} return (A)this;
  }
  public List<String> getApiGroups() {
    return this.apiGroups;
  }
  public String getApiGroup(Integer index) {
    return this.apiGroups.get(index);
  }
  public String getFirstApiGroup() {
    return this.apiGroups.get(0);
  }
  public String getLastApiGroup() {
    return this.apiGroups.get(apiGroups.size() - 1);
  }
  public String getMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApiGroups(List<String> apiGroups) {
    if (apiGroups != null) {this.apiGroups = new ArrayList(); for (String item : apiGroups){this.addToApiGroups(item);}} else { this.apiGroups = null;} return (A) this;
  }
  public A withApiGroups(java.lang.String... apiGroups) {
    if (this.apiGroups != null) {this.apiGroups.clear();}
    if (apiGroups != null) {for (String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
  }
  public Boolean hasApiGroups() {
    return apiGroups != null && !apiGroups.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildAttributeRestrictions instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getAttributeRestrictions() {
    return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
  }
  public HasMetadata buildAttributeRestrictions() {
    return this.attributeRestrictions!=null?this.attributeRestrictions.build():null;
  }
  public A withAttributeRestrictions(HasMetadata attributeRestrictions) {
    if (attributeRestrictions instanceof ImageStreamImport){ this.attributeRestrictions= new ImageStreamImportBuilder((ImageStreamImport)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Project){ this.attributeRestrictions= new ProjectBuilder((Project)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildConfig){ this.attributeRestrictions= new BuildConfigBuilder((BuildConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HelmChartRepository){ this.attributeRestrictions= new HelmChartRepositoryBuilder((HelmChartRepository)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RangeAllocation){ this.attributeRestrictions= new RangeAllocationBuilder((RangeAllocation)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Route){ this.attributeRestrictions= new RouteBuilder((Route)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterNetwork){ this.attributeRestrictions= new ClusterNetworkBuilder((ClusterNetwork)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAuthorizeToken){ this.attributeRestrictions= new OAuthAuthorizeTokenBuilder((OAuthAuthorizeToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserOAuthAccessToken){ this.attributeRestrictions= new UserOAuthAccessTokenBuilder((UserOAuthAccessToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRoleBinding){ this.attributeRestrictions= new ClusterRoleBindingBuilder((ClusterRoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterResourceQuota){ this.attributeRestrictions= new ClusterResourceQuotaBuilder((ClusterResourceQuota)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ProjectRequest){ this.attributeRestrictions= new ProjectRequestBuilder((ProjectRequest)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Template){ this.attributeRestrictions= new TemplateBuilder((Template)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClientAuthorization){ this.attributeRestrictions= new OAuthClientAuthorizationBuilder((OAuthClientAuthorization)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ClusterRole){ this.attributeRestrictions= new ClusterRoleBuilder((ClusterRole)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageTag){ this.attributeRestrictions= new ImageTagBuilder((ImageTag)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthAccessToken){ this.attributeRestrictions= new OAuthAccessTokenBuilder((OAuthAccessToken)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof DeploymentConfig){ this.attributeRestrictions= new DeploymentConfigBuilder((DeploymentConfig)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBinding){ this.attributeRestrictions= new RoleBindingBuilder((RoleBinding)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Image){ this.attributeRestrictions= new ImageBuilder((Image)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof PersistentVolumeClaim){ this.attributeRestrictions= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamMapping){ this.attributeRestrictions= new ImageStreamMappingBuilder((ImageStreamMapping)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Role){ this.attributeRestrictions= new RoleBuilder((Role)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BrokerTemplateInstance){ this.attributeRestrictions= new BrokerTemplateInstanceBuilder((BrokerTemplateInstance)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof User){ this.attributeRestrictions= new UserBuilder((User)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamImage){ this.attributeRestrictions= new ImageStreamImageBuilder((ImageStreamImage)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof TemplateInstance){ this.attributeRestrictions= new TemplateInstanceBuilder((TemplateInstance)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Build){ this.attributeRestrictions= new BuildBuilder((Build)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof RoleBindingRestriction){ this.attributeRestrictions= new RoleBindingRestrictionBuilder((RoleBindingRestriction)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStreamTag){ this.attributeRestrictions= new ImageStreamTagBuilder((ImageStreamTag)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Group){ this.attributeRestrictions= new GroupBuilder((Group)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageSignature){ this.attributeRestrictions= new ImageSignatureBuilder((ImageSignature)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof HostSubnet){ this.attributeRestrictions= new HostSubnetBuilder((HostSubnet)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof AppliedClusterResourceQuota){ this.attributeRestrictions= new AppliedClusterResourceQuotaBuilder((AppliedClusterResourceQuota)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof SecurityContextConstraints){ this.attributeRestrictions= new SecurityContextConstraintsBuilder((SecurityContextConstraints)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof BuildRequest){ this.attributeRestrictions= new BuildRequestBuilder((BuildRequest)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof EgressNetworkPolicy){ this.attributeRestrictions= new EgressNetworkPolicyBuilder((EgressNetworkPolicy)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof NetNamespace){ this.attributeRestrictions= new NetNamespaceBuilder((NetNamespace)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof UserIdentityMapping){ this.attributeRestrictions= new UserIdentityMappingBuilder((UserIdentityMapping)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof ImageStream){ this.attributeRestrictions= new ImageStreamBuilder((ImageStream)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof OAuthClient){ this.attributeRestrictions= new OAuthClientBuilder((OAuthClient)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    if (attributeRestrictions instanceof Identity){ this.attributeRestrictions= new IdentityBuilder((Identity)attributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);}
    return (A) this;
  }
  public Boolean hasAttributeRestrictions() {
    return this.attributeRestrictions != null;
  }
  public A withImageStreamImportAttributeRestrictions(ImageStreamImport imageStreamImportAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImportAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImportBuilder(imageStreamImportAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<A> withNewImageStreamImportAttributeRestrictionsLike(ImageStreamImport item) {
    return new PolicyRuleFluentImpl.ImageStreamImportAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectAttributeRestrictions(Project projectAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectBuilder(projectAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ProjectAttributeRestrictionsNested<A> withNewProjectAttributeRestrictionsLike(Project item) {
    return new PolicyRuleFluentImpl.ProjectAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildConfigAttributeRestrictions(BuildConfig buildConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildConfigAttributeRestrictions!=null){ this.attributeRestrictions= new BuildConfigBuilder(buildConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<A> withNewBuildConfigAttributeRestrictionsLike(BuildConfig item) {
    return new PolicyRuleFluentImpl.BuildConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withHelmChartRepositoryAttributeRestrictions(HelmChartRepository helmChartRepositoryAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (helmChartRepositoryAttributeRestrictions!=null){ this.attributeRestrictions= new HelmChartRepositoryBuilder(helmChartRepositoryAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<A> withNewHelmChartRepositoryAttributeRestrictionsLike(HelmChartRepository item) {
    return new PolicyRuleFluentImpl.HelmChartRepositoryAttributeRestrictionsNestedImpl(item);
  }
  public A withRangeAllocationAttributeRestrictions(RangeAllocation rangeAllocationAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (rangeAllocationAttributeRestrictions!=null){ this.attributeRestrictions= new RangeAllocationBuilder(rangeAllocationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<A> withNewRangeAllocationAttributeRestrictionsLike(RangeAllocation item) {
    return new PolicyRuleFluentImpl.RangeAllocationAttributeRestrictionsNestedImpl(item);
  }
  public A withRouteAttributeRestrictions(Route routeAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (routeAttributeRestrictions!=null){ this.attributeRestrictions= new RouteBuilder(routeAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RouteAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RouteAttributeRestrictionsNested<A> withNewRouteAttributeRestrictionsLike(Route item) {
    return new PolicyRuleFluentImpl.RouteAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterNetworkAttributeRestrictions(ClusterNetwork clusterNetworkAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterNetworkAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterNetworkBuilder(clusterNetworkAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<A> withNewClusterNetworkAttributeRestrictionsLike(ClusterNetwork item) {
    return new PolicyRuleFluentImpl.ClusterNetworkAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAuthorizeTokenAttributeRestrictions(OAuthAuthorizeToken oAuthAuthorizeTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAuthorizeTokenAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAuthorizeTokenBuilder(oAuthAuthorizeTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<A> withNewOAuthAuthorizeTokenAttributeRestrictionsLike(OAuthAuthorizeToken item) {
    return new PolicyRuleFluentImpl.OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withUserOAuthAccessTokenAttributeRestrictions(UserOAuthAccessToken userOAuthAccessTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userOAuthAccessTokenAttributeRestrictions!=null){ this.attributeRestrictions= new UserOAuthAccessTokenBuilder(userOAuthAccessTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<A> withNewUserOAuthAccessTokenAttributeRestrictionsLike(UserOAuthAccessToken item) {
    return new PolicyRuleFluentImpl.UserOAuthAccessTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleBindingAttributeRestrictions(ClusterRoleBinding clusterRoleBindingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBindingBuilder(clusterRoleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<A> withNewClusterRoleBindingAttributeRestrictionsLike(ClusterRoleBinding item) {
    return new PolicyRuleFluentImpl.ClusterRoleBindingAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterResourceQuotaAttributeRestrictions(ClusterResourceQuota clusterResourceQuotaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterResourceQuotaAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterResourceQuotaBuilder(clusterResourceQuotaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<A> withNewClusterResourceQuotaAttributeRestrictionsLike(ClusterResourceQuota item) {
    return new PolicyRuleFluentImpl.ClusterResourceQuotaAttributeRestrictionsNestedImpl(item);
  }
  public A withProjectRequestAttributeRestrictions(ProjectRequest projectRequestAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (projectRequestAttributeRestrictions!=null){ this.attributeRestrictions= new ProjectRequestBuilder(projectRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<A> withNewProjectRequestAttributeRestrictionsLike(ProjectRequest item) {
    return new PolicyRuleFluentImpl.ProjectRequestAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateAttributeRestrictions(Template templateAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateBuilder(templateAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateAttributeRestrictionsNested<A> withNewTemplateAttributeRestrictionsLike(Template item) {
    return new PolicyRuleFluentImpl.TemplateAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthClientAuthorizationAttributeRestrictions(OAuthClientAuthorization oAuthClientAuthorizationAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAuthorizationAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientAuthorizationBuilder(oAuthClientAuthorizationAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<A> withNewOAuthClientAuthorizationAttributeRestrictionsLike(OAuthClientAuthorization item) {
    return new PolicyRuleFluentImpl.OAuthClientAuthorizationAttributeRestrictionsNestedImpl(item);
  }
  public A withClusterRoleAttributeRestrictions(ClusterRole clusterRoleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (clusterRoleAttributeRestrictions!=null){ this.attributeRestrictions= new ClusterRoleBuilder(clusterRoleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<A> withNewClusterRoleAttributeRestrictionsLike(ClusterRole item) {
    return new PolicyRuleFluentImpl.ClusterRoleAttributeRestrictionsNestedImpl(item);
  }
  public A withImageTagAttributeRestrictions(ImageTag imageTagAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageTagAttributeRestrictions!=null){ this.attributeRestrictions= new ImageTagBuilder(imageTagAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageTagAttributeRestrictionsNested<A> withNewImageTagAttributeRestrictionsLike(ImageTag item) {
    return new PolicyRuleFluentImpl.ImageTagAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthAccessTokenAttributeRestrictions(OAuthAccessToken oAuthAccessTokenAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthAccessTokenAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthAccessTokenBuilder(oAuthAccessTokenAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<A> withNewOAuthAccessTokenAttributeRestrictionsLike(OAuthAccessToken item) {
    return new PolicyRuleFluentImpl.OAuthAccessTokenAttributeRestrictionsNestedImpl(item);
  }
  public A withDeploymentConfigAttributeRestrictions(DeploymentConfig deploymentConfigAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (deploymentConfigAttributeRestrictions!=null){ this.attributeRestrictions= new DeploymentConfigBuilder(deploymentConfigAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictions() {
    return new PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<A> withNewDeploymentConfigAttributeRestrictionsLike(DeploymentConfig item) {
    return new PolicyRuleFluentImpl.DeploymentConfigAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingAttributeRestrictions(RoleBinding roleBindingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingBuilder(roleBindingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<A> withNewRoleBindingAttributeRestrictionsLike(RoleBinding item) {
    return new PolicyRuleFluentImpl.RoleBindingAttributeRestrictionsNestedImpl(item);
  }
  public A withImageAttributeRestrictions(Image imageAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageAttributeRestrictions!=null){ this.attributeRestrictions= new ImageBuilder(imageAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageAttributeRestrictionsNested<A> withNewImageAttributeRestrictionsLike(Image item) {
    return new PolicyRuleFluentImpl.ImageAttributeRestrictionsNestedImpl(item);
  }
  public A withPersistentVolumeClaimAttributeRestrictions(PersistentVolumeClaim persistentVolumeClaimAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (persistentVolumeClaimAttributeRestrictions!=null){ this.attributeRestrictions= new PersistentVolumeClaimBuilder(persistentVolumeClaimAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictions() {
    return new PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<A> withNewPersistentVolumeClaimAttributeRestrictionsLike(PersistentVolumeClaim item) {
    return new PolicyRuleFluentImpl.PersistentVolumeClaimAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamMappingAttributeRestrictions(ImageStreamMapping imageStreamMappingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamMappingAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamMappingBuilder(imageStreamMappingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<A> withNewImageStreamMappingAttributeRestrictionsLike(ImageStreamMapping item) {
    return new PolicyRuleFluentImpl.ImageStreamMappingAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleAttributeRestrictions(Role roleAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBuilder(roleAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleAttributeRestrictionsNested<A> withNewRoleAttributeRestrictionsLike(Role item) {
    return new PolicyRuleFluentImpl.RoleAttributeRestrictionsNestedImpl(item);
  }
  public A withBrokerTemplateInstanceAttributeRestrictions(BrokerTemplateInstance brokerTemplateInstanceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (brokerTemplateInstanceAttributeRestrictions!=null){ this.attributeRestrictions= new BrokerTemplateInstanceBuilder(brokerTemplateInstanceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<A> withNewBrokerTemplateInstanceAttributeRestrictionsLike(BrokerTemplateInstance item) {
    return new PolicyRuleFluentImpl.BrokerTemplateInstanceAttributeRestrictionsNestedImpl(item);
  }
  public A withUserAttributeRestrictions(User userAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userAttributeRestrictions!=null){ this.attributeRestrictions= new UserBuilder(userAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.UserAttributeRestrictionsNested<A> withNewUserAttributeRestrictionsLike(User item) {
    return new PolicyRuleFluentImpl.UserAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamImageAttributeRestrictions(ImageStreamImage imageStreamImageAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamImageAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamImageBuilder(imageStreamImageAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<A> withNewImageStreamImageAttributeRestrictionsLike(ImageStreamImage item) {
    return new PolicyRuleFluentImpl.ImageStreamImageAttributeRestrictionsNestedImpl(item);
  }
  public A withTemplateInstanceAttributeRestrictions(TemplateInstance templateInstanceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (templateInstanceAttributeRestrictions!=null){ this.attributeRestrictions= new TemplateInstanceBuilder(templateInstanceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<A> withNewTemplateInstanceAttributeRestrictionsLike(TemplateInstance item) {
    return new PolicyRuleFluentImpl.TemplateInstanceAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildAttributeRestrictions(Build buildAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildAttributeRestrictions!=null){ this.attributeRestrictions= new BuildBuilder(buildAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildAttributeRestrictionsNested<A> withNewBuildAttributeRestrictionsLike(Build item) {
    return new PolicyRuleFluentImpl.BuildAttributeRestrictionsNestedImpl(item);
  }
  public A withRoleBindingRestrictionAttributeRestrictions(RoleBindingRestriction roleBindingRestrictionAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (roleBindingRestrictionAttributeRestrictions!=null){ this.attributeRestrictions= new RoleBindingRestrictionBuilder(roleBindingRestrictionAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictions() {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<A> withNewRoleBindingRestrictionAttributeRestrictionsLike(RoleBindingRestriction item) {
    return new PolicyRuleFluentImpl.RoleBindingRestrictionAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamTagAttributeRestrictions(ImageStreamTag imageStreamTagAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamTagAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamTagBuilder(imageStreamTagAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<A> withNewImageStreamTagAttributeRestrictionsLike(ImageStreamTag item) {
    return new PolicyRuleFluentImpl.ImageStreamTagAttributeRestrictionsNestedImpl(item);
  }
  public A withGroupAttributeRestrictions(Group groupAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (groupAttributeRestrictions!=null){ this.attributeRestrictions= new GroupBuilder(groupAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictions() {
    return new PolicyRuleFluentImpl.GroupAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.GroupAttributeRestrictionsNested<A> withNewGroupAttributeRestrictionsLike(Group item) {
    return new PolicyRuleFluentImpl.GroupAttributeRestrictionsNestedImpl(item);
  }
  public A withImageSignatureAttributeRestrictions(ImageSignature imageSignatureAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageSignatureAttributeRestrictions!=null){ this.attributeRestrictions= new ImageSignatureBuilder(imageSignatureAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<A> withNewImageSignatureAttributeRestrictionsLike(ImageSignature item) {
    return new PolicyRuleFluentImpl.ImageSignatureAttributeRestrictionsNestedImpl(item);
  }
  public A withHostSubnetAttributeRestrictions(HostSubnet hostSubnetAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (hostSubnetAttributeRestrictions!=null){ this.attributeRestrictions= new HostSubnetBuilder(hostSubnetAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictions() {
    return new PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<A> withNewHostSubnetAttributeRestrictionsLike(HostSubnet item) {
    return new PolicyRuleFluentImpl.HostSubnetAttributeRestrictionsNestedImpl(item);
  }
  public A withAppliedClusterResourceQuotaAttributeRestrictions(AppliedClusterResourceQuota appliedClusterResourceQuotaAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (appliedClusterResourceQuotaAttributeRestrictions!=null){ this.attributeRestrictions= new AppliedClusterResourceQuotaBuilder(appliedClusterResourceQuotaAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictions() {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<A> withNewAppliedClusterResourceQuotaAttributeRestrictionsLike(AppliedClusterResourceQuota item) {
    return new PolicyRuleFluentImpl.AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl(item);
  }
  public A withSecurityContextConstraintsAttributeRestrictions(SecurityContextConstraints securityContextConstraintsAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (securityContextConstraintsAttributeRestrictions!=null){ this.attributeRestrictions= new SecurityContextConstraintsBuilder(securityContextConstraintsAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictions() {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<A> withNewSecurityContextConstraintsAttributeRestrictionsLike(SecurityContextConstraints item) {
    return new PolicyRuleFluentImpl.SecurityContextConstraintsAttributeRestrictionsNestedImpl(item);
  }
  public A withBuildRequestAttributeRestrictions(BuildRequest buildRequestAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (buildRequestAttributeRestrictions!=null){ this.attributeRestrictions= new BuildRequestBuilder(buildRequestAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictions() {
    return new PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<A> withNewBuildRequestAttributeRestrictionsLike(BuildRequest item) {
    return new PolicyRuleFluentImpl.BuildRequestAttributeRestrictionsNestedImpl(item);
  }
  public A withEgressNetworkPolicyAttributeRestrictions(EgressNetworkPolicy egressNetworkPolicyAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (egressNetworkPolicyAttributeRestrictions!=null){ this.attributeRestrictions= new EgressNetworkPolicyBuilder(egressNetworkPolicyAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictions() {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<A> withNewEgressNetworkPolicyAttributeRestrictionsLike(EgressNetworkPolicy item) {
    return new PolicyRuleFluentImpl.EgressNetworkPolicyAttributeRestrictionsNestedImpl(item);
  }
  public A withNetNamespaceAttributeRestrictions(NetNamespace netNamespaceAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (netNamespaceAttributeRestrictions!=null){ this.attributeRestrictions= new NetNamespaceBuilder(netNamespaceAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictions() {
    return new PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<A> withNewNetNamespaceAttributeRestrictionsLike(NetNamespace item) {
    return new PolicyRuleFluentImpl.NetNamespaceAttributeRestrictionsNestedImpl(item);
  }
  public A withUserIdentityMappingAttributeRestrictions(UserIdentityMapping userIdentityMappingAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (userIdentityMappingAttributeRestrictions!=null){ this.attributeRestrictions= new UserIdentityMappingBuilder(userIdentityMappingAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictions() {
    return new PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<A> withNewUserIdentityMappingAttributeRestrictionsLike(UserIdentityMapping item) {
    return new PolicyRuleFluentImpl.UserIdentityMappingAttributeRestrictionsNestedImpl(item);
  }
  public A withImageStreamAttributeRestrictions(ImageStream imageStreamAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (imageStreamAttributeRestrictions!=null){ this.attributeRestrictions= new ImageStreamBuilder(imageStreamAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictions() {
    return new PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<A> withNewImageStreamAttributeRestrictionsLike(ImageStream item) {
    return new PolicyRuleFluentImpl.ImageStreamAttributeRestrictionsNestedImpl(item);
  }
  public A withOAuthClientAttributeRestrictions(OAuthClient oAuthClientAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (oAuthClientAttributeRestrictions!=null){ this.attributeRestrictions= new OAuthClientBuilder(oAuthClientAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictions() {
    return new PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<A> withNewOAuthClientAttributeRestrictionsLike(OAuthClient item) {
    return new PolicyRuleFluentImpl.OAuthClientAttributeRestrictionsNestedImpl(item);
  }
  public A withIdentityAttributeRestrictions(Identity identityAttributeRestrictions) {
    _visitables.get("attributeRestrictions").remove(this.attributeRestrictions);
    if (identityAttributeRestrictions!=null){ this.attributeRestrictions= new IdentityBuilder(identityAttributeRestrictions); _visitables.get("attributeRestrictions").add(this.attributeRestrictions);} else { this.attributeRestrictions = null; _visitables.get("attributeRestrictions").remove(this.attributeRestrictions); } return (A) this;
  }
  public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictions() {
    return new PolicyRuleFluentImpl.IdentityAttributeRestrictionsNestedImpl();
  }
  public PolicyRuleFluent.IdentityAttributeRestrictionsNested<A> withNewIdentityAttributeRestrictionsLike(Identity item) {
    return new PolicyRuleFluentImpl.IdentityAttributeRestrictionsNestedImpl(item);
  }
  public A addToNonResourceURLs(Integer index,String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    this.nonResourceURLs.add(index, item);
    return (A)this;
  }
  public A setToNonResourceURLs(Integer index,String item) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    this.nonResourceURLs.set(index, item); return (A)this;
  }
  public A addToNonResourceURLs(java.lang.String... items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  public A addAllToNonResourceURLs(Collection<String> items) {
    if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
    for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
  }
  public A removeFromNonResourceURLs(java.lang.String... items) {
    for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
  }
  public A removeAllFromNonResourceURLs(Collection<String> items) {
    for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
  }
  public List<String> getNonResourceURLs() {
    return this.nonResourceURLs;
  }
  public String getNonResourceURL(Integer index) {
    return this.nonResourceURLs.get(index);
  }
  public String getFirstNonResourceURL() {
    return this.nonResourceURLs.get(0);
  }
  public String getLastNonResourceURL() {
    return this.nonResourceURLs.get(nonResourceURLs.size() - 1);
  }
  public String getMatchingNonResourceURL(Predicate<String> predicate) {
    for (String item: nonResourceURLs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
    for (String item: nonResourceURLs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNonResourceURLs(List<String> nonResourceURLs) {
    if (nonResourceURLs != null) {this.nonResourceURLs = new ArrayList(); for (String item : nonResourceURLs){this.addToNonResourceURLs(item);}} else { this.nonResourceURLs = null;} return (A) this;
  }
  public A withNonResourceURLs(java.lang.String... nonResourceURLs) {
    if (this.nonResourceURLs != null) {this.nonResourceURLs.clear();}
    if (nonResourceURLs != null) {for (String item :nonResourceURLs){ this.addToNonResourceURLs(item);}} return (A) this;
  }
  public Boolean hasNonResourceURLs() {
    return nonResourceURLs != null && !nonResourceURLs.isEmpty();
  }
  public A addToResourceNames(Integer index,String item) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    this.resourceNames.add(index, item);
    return (A)this;
  }
  public A setToResourceNames(Integer index,String item) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    this.resourceNames.set(index, item); return (A)this;
  }
  public A addToResourceNames(java.lang.String... items) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    for (String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  public A addAllToResourceNames(Collection<String> items) {
    if (this.resourceNames == null) {this.resourceNames = new ArrayList<String>();}
    for (String item : items) {this.resourceNames.add(item);} return (A)this;
  }
  public A removeFromResourceNames(java.lang.String... items) {
    for (String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
  }
  public A removeAllFromResourceNames(Collection<String> items) {
    for (String item : items) {if (this.resourceNames!= null){ this.resourceNames.remove(item);}} return (A)this;
  }
  public List<String> getResourceNames() {
    return this.resourceNames;
  }
  public String getResourceName(Integer index) {
    return this.resourceNames.get(index);
  }
  public String getFirstResourceName() {
    return this.resourceNames.get(0);
  }
  public String getLastResourceName() {
    return this.resourceNames.get(resourceNames.size() - 1);
  }
  public String getMatchingResourceName(Predicate<String> predicate) {
    for (String item: resourceNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingResourceName(Predicate<String> predicate) {
    for (String item: resourceNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceNames(List<String> resourceNames) {
    if (resourceNames != null) {this.resourceNames = new ArrayList(); for (String item : resourceNames){this.addToResourceNames(item);}} else { this.resourceNames = null;} return (A) this;
  }
  public A withResourceNames(java.lang.String... resourceNames) {
    if (this.resourceNames != null) {this.resourceNames.clear();}
    if (resourceNames != null) {for (String item :resourceNames){ this.addToResourceNames(item);}} return (A) this;
  }
  public Boolean hasResourceNames() {
    return resourceNames != null && !resourceNames.isEmpty();
  }
  public A addToResources(Integer index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.add(index, item);
    return (A)this;
  }
  public A setToResources(Integer index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.set(index, item); return (A)this;
  }
  public A addToResources(java.lang.String... items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A addAllToResources(Collection<String> items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A removeFromResources(java.lang.String... items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public A removeAllFromResources(Collection<String> items) {
    for (String item : items) {if (this.resources!= null){ this.resources.remove(item);}} return (A)this;
  }
  public List<String> getResources() {
    return this.resources;
  }
  public String getResource(Integer index) {
    return this.resources.get(index);
  }
  public String getFirstResource() {
    return this.resources.get(0);
  }
  public String getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  public String getMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<String> resources) {
    if (resources != null) {this.resources = new ArrayList(); for (String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(java.lang.String... resources) {
    if (this.resources != null) {this.resources.clear();}
    if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
  }
  public Boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public A addToVerbs(Integer index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.add(index, item);
    return (A)this;
  }
  public A setToVerbs(Integer index,String item) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    this.verbs.set(index, item); return (A)this;
  }
  public A addToVerbs(java.lang.String... items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A addAllToVerbs(Collection<String> items) {
    if (this.verbs == null) {this.verbs = new ArrayList<String>();}
    for (String item : items) {this.verbs.add(item);} return (A)this;
  }
  public A removeFromVerbs(java.lang.String... items) {
    for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public A removeAllFromVerbs(Collection<String> items) {
    for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
  }
  public List<String> getVerbs() {
    return this.verbs;
  }
  public String getVerb(Integer index) {
    return this.verbs.get(index);
  }
  public String getFirstVerb() {
    return this.verbs.get(0);
  }
  public String getLastVerb() {
    return this.verbs.get(verbs.size() - 1);
  }
  public String getMatchingVerb(Predicate<String> predicate) {
    for (String item: verbs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVerb(Predicate<String> predicate) {
    for (String item: verbs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVerbs(List<String> verbs) {
    if (verbs != null) {this.verbs = new ArrayList(); for (String item : verbs){this.addToVerbs(item);}} else { this.verbs = null;} return (A) this;
  }
  public A withVerbs(java.lang.String... verbs) {
    if (this.verbs != null) {this.verbs.clear();}
    if (verbs != null) {for (String item :verbs){ this.addToVerbs(item);}} return (A) this;
  }
  public Boolean hasVerbs() {
    return verbs != null && !verbs.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PolicyRuleFluentImpl that = (PolicyRuleFluentImpl) o;
    if (apiGroups != null ? !apiGroups.equals(that.apiGroups) :that.apiGroups != null) return false;
    if (attributeRestrictions != null ? !attributeRestrictions.equals(that.attributeRestrictions) :that.attributeRestrictions != null) return false;
    if (nonResourceURLs != null ? !nonResourceURLs.equals(that.nonResourceURLs) :that.nonResourceURLs != null) return false;
    if (resourceNames != null ? !resourceNames.equals(that.resourceNames) :that.resourceNames != null) return false;
    if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
    if (verbs != null ? !verbs.equals(that.verbs) :that.verbs != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiGroups,  attributeRestrictions,  nonResourceURLs,  resourceNames,  resources,  verbs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiGroups != null && !apiGroups.isEmpty()) { sb.append("apiGroups:"); sb.append(apiGroups + ","); }
    if (attributeRestrictions != null) { sb.append("attributeRestrictions:"); sb.append(attributeRestrictions + ","); }
    if (nonResourceURLs != null && !nonResourceURLs.isEmpty()) { sb.append("nonResourceURLs:"); sb.append(nonResourceURLs + ","); }
    if (resourceNames != null && !resourceNames.isEmpty()) { sb.append("resourceNames:"); sb.append(resourceNames + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (verbs != null && !verbs.isEmpty()) { sb.append("verbs:"); sb.append(verbs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageStreamImportAttributeRestrictionsNestedImpl<N> extends ImageStreamImportFluentImpl<PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamImportAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImportAttributeRestrictionsNestedImpl(ImageStreamImport item) {
      this.builder = new ImageStreamImportBuilder(this, item);
    }
    ImageStreamImportAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImportBuilder(this);
    }
    ImageStreamImportBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImportAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectAttributeRestrictionsNestedImpl<N> extends ProjectFluentImpl<PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ProjectAttributeRestrictionsNested<N>,Nested<N>{
    ProjectAttributeRestrictionsNestedImpl(Project item) {
      this.builder = new ProjectBuilder(this, item);
    }
    ProjectAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectBuilder(this);
    }
    ProjectBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildConfigAttributeRestrictionsNestedImpl<N> extends BuildConfigFluentImpl<PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildConfigAttributeRestrictionsNested<N>,Nested<N>{
    BuildConfigAttributeRestrictionsNestedImpl(BuildConfig item) {
      this.builder = new BuildConfigBuilder(this, item);
    }
    BuildConfigAttributeRestrictionsNestedImpl() {
      this.builder = new BuildConfigBuilder(this);
    }
    BuildConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class HelmChartRepositoryAttributeRestrictionsNestedImpl<N> extends HelmChartRepositoryFluentImpl<PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<N>> implements PolicyRuleFluent.HelmChartRepositoryAttributeRestrictionsNested<N>,Nested<N>{
    HelmChartRepositoryAttributeRestrictionsNestedImpl(HelmChartRepository item) {
      this.builder = new HelmChartRepositoryBuilder(this, item);
    }
    HelmChartRepositoryAttributeRestrictionsNestedImpl() {
      this.builder = new HelmChartRepositoryBuilder(this);
    }
    HelmChartRepositoryBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHelmChartRepositoryAttributeRestrictions() {
      return and();
    }
    
  }
  class RangeAllocationAttributeRestrictionsNestedImpl<N> extends RangeAllocationFluentImpl<PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RangeAllocationAttributeRestrictionsNested<N>,Nested<N>{
    RangeAllocationAttributeRestrictionsNestedImpl(RangeAllocation item) {
      this.builder = new RangeAllocationBuilder(this, item);
    }
    RangeAllocationAttributeRestrictionsNestedImpl() {
      this.builder = new RangeAllocationBuilder(this);
    }
    RangeAllocationBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRangeAllocationAttributeRestrictions() {
      return and();
    }
    
  }
  class RouteAttributeRestrictionsNestedImpl<N> extends RouteFluentImpl<PolicyRuleFluent.RouteAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RouteAttributeRestrictionsNested<N>,Nested<N>{
    RouteAttributeRestrictionsNestedImpl(Route item) {
      this.builder = new RouteBuilder(this, item);
    }
    RouteAttributeRestrictionsNestedImpl() {
      this.builder = new RouteBuilder(this);
    }
    RouteBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRouteAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterNetworkAttributeRestrictionsNestedImpl<N> extends ClusterNetworkFluentImpl<PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterNetworkAttributeRestrictionsNested<N>,Nested<N>{
    ClusterNetworkAttributeRestrictionsNestedImpl(ClusterNetwork item) {
      this.builder = new ClusterNetworkBuilder(this, item);
    }
    ClusterNetworkAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterNetworkBuilder(this);
    }
    ClusterNetworkBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterNetworkAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAuthorizeTokenAttributeRestrictionsNestedImpl<N> extends OAuthAuthorizeTokenFluentImpl<PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthAuthorizeTokenAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAuthorizeTokenAttributeRestrictionsNestedImpl(OAuthAuthorizeToken item) {
      this.builder = new OAuthAuthorizeTokenBuilder(this, item);
    }
    OAuthAuthorizeTokenAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAuthorizeTokenBuilder(this);
    }
    OAuthAuthorizeTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAuthorizeTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class UserOAuthAccessTokenAttributeRestrictionsNestedImpl<N> extends UserOAuthAccessTokenFluentImpl<PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserOAuthAccessTokenAttributeRestrictionsNested<N>,Nested<N>{
    UserOAuthAccessTokenAttributeRestrictionsNestedImpl(UserOAuthAccessToken item) {
      this.builder = new UserOAuthAccessTokenBuilder(this, item);
    }
    UserOAuthAccessTokenAttributeRestrictionsNestedImpl() {
      this.builder = new UserOAuthAccessTokenBuilder(this);
    }
    UserOAuthAccessTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleBindingAttributeRestrictionsNestedImpl<N> extends ClusterRoleBindingFluentImpl<PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterRoleBindingAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleBindingAttributeRestrictionsNestedImpl(ClusterRoleBinding item) {
      this.builder = new ClusterRoleBindingBuilder(this, item);
    }
    ClusterRoleBindingAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleBindingBuilder(this);
    }
    ClusterRoleBindingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleBindingAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterResourceQuotaAttributeRestrictionsNestedImpl<N> extends ClusterResourceQuotaFluentImpl<PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterResourceQuotaAttributeRestrictionsNested<N>,Nested<N>{
    ClusterResourceQuotaAttributeRestrictionsNestedImpl(ClusterResourceQuota item) {
      this.builder = new ClusterResourceQuotaBuilder(this, item);
    }
    ClusterResourceQuotaAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterResourceQuotaBuilder(this);
    }
    ClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  }
  class ProjectRequestAttributeRestrictionsNestedImpl<N> extends ProjectRequestFluentImpl<PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ProjectRequestAttributeRestrictionsNested<N>,Nested<N>{
    ProjectRequestAttributeRestrictionsNestedImpl(ProjectRequest item) {
      this.builder = new ProjectRequestBuilder(this, item);
    }
    ProjectRequestAttributeRestrictionsNestedImpl() {
      this.builder = new ProjectRequestBuilder(this);
    }
    ProjectRequestBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endProjectRequestAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateAttributeRestrictionsNestedImpl<N> extends TemplateFluentImpl<PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateAttributeRestrictionsNested<N>,Nested<N>{
    TemplateAttributeRestrictionsNestedImpl(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateBuilder(this);
    }
    TemplateBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAuthorizationAttributeRestrictionsNestedImpl<N> extends OAuthClientAuthorizationFluentImpl<PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthClientAuthorizationAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientAuthorizationAttributeRestrictionsNestedImpl(OAuthClientAuthorization item) {
      this.builder = new OAuthClientAuthorizationBuilder(this, item);
    }
    OAuthClientAuthorizationAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientAuthorizationBuilder(this);
    }
    OAuthClientAuthorizationBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAuthorizationAttributeRestrictions() {
      return and();
    }
    
  }
  class ClusterRoleAttributeRestrictionsNestedImpl<N> extends ClusterRoleFluentImpl<PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ClusterRoleAttributeRestrictionsNested<N>,Nested<N>{
    ClusterRoleAttributeRestrictionsNestedImpl(ClusterRole item) {
      this.builder = new ClusterRoleBuilder(this, item);
    }
    ClusterRoleAttributeRestrictionsNestedImpl() {
      this.builder = new ClusterRoleBuilder(this);
    }
    ClusterRoleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endClusterRoleAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageTagAttributeRestrictionsNestedImpl<N> extends ImageTagFluentImpl<PolicyRuleFluent.ImageTagAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageTagAttributeRestrictionsNested<N>,Nested<N>{
    ImageTagAttributeRestrictionsNestedImpl(ImageTag item) {
      this.builder = new ImageTagBuilder(this, item);
    }
    ImageTagAttributeRestrictionsNestedImpl() {
      this.builder = new ImageTagBuilder(this);
    }
    ImageTagBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageTagAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthAccessTokenAttributeRestrictionsNestedImpl<N> extends OAuthAccessTokenFluentImpl<PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthAccessTokenAttributeRestrictionsNested<N>,Nested<N>{
    OAuthAccessTokenAttributeRestrictionsNestedImpl(OAuthAccessToken item) {
      this.builder = new OAuthAccessTokenBuilder(this, item);
    }
    OAuthAccessTokenAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthAccessTokenBuilder(this);
    }
    OAuthAccessTokenBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthAccessTokenAttributeRestrictions() {
      return and();
    }
    
  }
  class DeploymentConfigAttributeRestrictionsNestedImpl<N> extends DeploymentConfigFluentImpl<PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>> implements PolicyRuleFluent.DeploymentConfigAttributeRestrictionsNested<N>,Nested<N>{
    DeploymentConfigAttributeRestrictionsNestedImpl(DeploymentConfig item) {
      this.builder = new DeploymentConfigBuilder(this, item);
    }
    DeploymentConfigAttributeRestrictionsNestedImpl() {
      this.builder = new DeploymentConfigBuilder(this);
    }
    DeploymentConfigBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endDeploymentConfigAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingAttributeRestrictionsNestedImpl<N> extends RoleBindingFluentImpl<PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleBindingAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingAttributeRestrictionsNestedImpl(RoleBinding item) {
      this.builder = new RoleBindingBuilder(this, item);
    }
    RoleBindingAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingBuilder(this);
    }
    RoleBindingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageAttributeRestrictionsNestedImpl<N> extends ImageFluentImpl<PolicyRuleFluent.ImageAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageAttributeRestrictionsNested<N>,Nested<N>{
    ImageAttributeRestrictionsNestedImpl(Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageAttributeRestrictionsNestedImpl() {
      this.builder = new ImageBuilder(this);
    }
    ImageBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageAttributeRestrictions() {
      return and();
    }
    
  }
  class PersistentVolumeClaimAttributeRestrictionsNestedImpl<N> extends PersistentVolumeClaimFluentImpl<PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>> implements PolicyRuleFluent.PersistentVolumeClaimAttributeRestrictionsNested<N>,Nested<N>{
    PersistentVolumeClaimAttributeRestrictionsNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimAttributeRestrictionsNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endPersistentVolumeClaimAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamMappingAttributeRestrictionsNestedImpl<N> extends ImageStreamMappingFluentImpl<PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamMappingAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamMappingAttributeRestrictionsNestedImpl(ImageStreamMapping item) {
      this.builder = new ImageStreamMappingBuilder(this, item);
    }
    ImageStreamMappingAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamMappingBuilder(this);
    }
    ImageStreamMappingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamMappingAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleAttributeRestrictionsNestedImpl<N> extends RoleFluentImpl<PolicyRuleFluent.RoleAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleAttributeRestrictionsNested<N>,Nested<N>{
    RoleAttributeRestrictionsNestedImpl(Role item) {
      this.builder = new RoleBuilder(this, item);
    }
    RoleAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBuilder(this);
    }
    RoleBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleAttributeRestrictions() {
      return and();
    }
    
  }
  class BrokerTemplateInstanceAttributeRestrictionsNestedImpl<N> extends BrokerTemplateInstanceFluentImpl<PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BrokerTemplateInstanceAttributeRestrictionsNested<N>,Nested<N>{
    BrokerTemplateInstanceAttributeRestrictionsNestedImpl(BrokerTemplateInstance item) {
      this.builder = new BrokerTemplateInstanceBuilder(this, item);
    }
    BrokerTemplateInstanceAttributeRestrictionsNestedImpl() {
      this.builder = new BrokerTemplateInstanceBuilder(this);
    }
    BrokerTemplateInstanceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBrokerTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  }
  class UserAttributeRestrictionsNestedImpl<N> extends UserFluentImpl<PolicyRuleFluent.UserAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserAttributeRestrictionsNested<N>,Nested<N>{
    UserAttributeRestrictionsNestedImpl(User item) {
      this.builder = new UserBuilder(this, item);
    }
    UserAttributeRestrictionsNestedImpl() {
      this.builder = new UserBuilder(this);
    }
    UserBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamImageAttributeRestrictionsNestedImpl<N> extends ImageStreamImageFluentImpl<PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamImageAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamImageAttributeRestrictionsNestedImpl(ImageStreamImage item) {
      this.builder = new ImageStreamImageBuilder(this, item);
    }
    ImageStreamImageAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamImageBuilder(this);
    }
    ImageStreamImageBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamImageAttributeRestrictions() {
      return and();
    }
    
  }
  class TemplateInstanceAttributeRestrictionsNestedImpl<N> extends TemplateInstanceFluentImpl<PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.TemplateInstanceAttributeRestrictionsNested<N>,Nested<N>{
    TemplateInstanceAttributeRestrictionsNestedImpl(TemplateInstance item) {
      this.builder = new TemplateInstanceBuilder(this, item);
    }
    TemplateInstanceAttributeRestrictionsNestedImpl() {
      this.builder = new TemplateInstanceBuilder(this);
    }
    TemplateInstanceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endTemplateInstanceAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildAttributeRestrictionsNestedImpl<N> extends BuildFluentImpl<PolicyRuleFluent.BuildAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildAttributeRestrictionsNested<N>,Nested<N>{
    BuildAttributeRestrictionsNestedImpl(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildAttributeRestrictionsNestedImpl() {
      this.builder = new BuildBuilder(this);
    }
    BuildBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildAttributeRestrictions() {
      return and();
    }
    
  }
  class RoleBindingRestrictionAttributeRestrictionsNestedImpl<N> extends RoleBindingRestrictionFluentImpl<PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>> implements PolicyRuleFluent.RoleBindingRestrictionAttributeRestrictionsNested<N>,Nested<N>{
    RoleBindingRestrictionAttributeRestrictionsNestedImpl(RoleBindingRestriction item) {
      this.builder = new RoleBindingRestrictionBuilder(this, item);
    }
    RoleBindingRestrictionAttributeRestrictionsNestedImpl() {
      this.builder = new RoleBindingRestrictionBuilder(this);
    }
    RoleBindingRestrictionBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endRoleBindingRestrictionAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamTagAttributeRestrictionsNestedImpl<N> extends ImageStreamTagFluentImpl<PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamTagAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamTagAttributeRestrictionsNestedImpl(ImageStreamTag item) {
      this.builder = new ImageStreamTagBuilder(this, item);
    }
    ImageStreamTagAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamTagBuilder(this);
    }
    ImageStreamTagBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamTagAttributeRestrictions() {
      return and();
    }
    
  }
  class GroupAttributeRestrictionsNestedImpl<N> extends GroupFluentImpl<PolicyRuleFluent.GroupAttributeRestrictionsNested<N>> implements PolicyRuleFluent.GroupAttributeRestrictionsNested<N>,Nested<N>{
    GroupAttributeRestrictionsNestedImpl(Group item) {
      this.builder = new GroupBuilder(this, item);
    }
    GroupAttributeRestrictionsNestedImpl() {
      this.builder = new GroupBuilder(this);
    }
    GroupBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endGroupAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageSignatureAttributeRestrictionsNestedImpl<N> extends ImageSignatureFluentImpl<PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageSignatureAttributeRestrictionsNested<N>,Nested<N>{
    ImageSignatureAttributeRestrictionsNestedImpl(ImageSignature item) {
      this.builder = new ImageSignatureBuilder(this, item);
    }
    ImageSignatureAttributeRestrictionsNestedImpl() {
      this.builder = new ImageSignatureBuilder(this);
    }
    ImageSignatureBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageSignatureAttributeRestrictions() {
      return and();
    }
    
  }
  class HostSubnetAttributeRestrictionsNestedImpl<N> extends HostSubnetFluentImpl<PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<N>> implements PolicyRuleFluent.HostSubnetAttributeRestrictionsNested<N>,Nested<N>{
    HostSubnetAttributeRestrictionsNestedImpl(HostSubnet item) {
      this.builder = new HostSubnetBuilder(this, item);
    }
    HostSubnetAttributeRestrictionsNestedImpl() {
      this.builder = new HostSubnetBuilder(this);
    }
    HostSubnetBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endHostSubnetAttributeRestrictions() {
      return and();
    }
    
  }
  class AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl<N> extends AppliedClusterResourceQuotaFluentImpl<PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>> implements PolicyRuleFluent.AppliedClusterResourceQuotaAttributeRestrictionsNested<N>,Nested<N>{
    AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl(AppliedClusterResourceQuota item) {
      this.builder = new AppliedClusterResourceQuotaBuilder(this, item);
    }
    AppliedClusterResourceQuotaAttributeRestrictionsNestedImpl() {
      this.builder = new AppliedClusterResourceQuotaBuilder(this);
    }
    AppliedClusterResourceQuotaBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endAppliedClusterResourceQuotaAttributeRestrictions() {
      return and();
    }
    
  }
  class SecurityContextConstraintsAttributeRestrictionsNestedImpl<N> extends SecurityContextConstraintsFluentImpl<PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>> implements PolicyRuleFluent.SecurityContextConstraintsAttributeRestrictionsNested<N>,Nested<N>{
    SecurityContextConstraintsAttributeRestrictionsNestedImpl(SecurityContextConstraints item) {
      this.builder = new SecurityContextConstraintsBuilder(this, item);
    }
    SecurityContextConstraintsAttributeRestrictionsNestedImpl() {
      this.builder = new SecurityContextConstraintsBuilder(this);
    }
    SecurityContextConstraintsBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endSecurityContextConstraintsAttributeRestrictions() {
      return and();
    }
    
  }
  class BuildRequestAttributeRestrictionsNestedImpl<N> extends BuildRequestFluentImpl<PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>> implements PolicyRuleFluent.BuildRequestAttributeRestrictionsNested<N>,Nested<N>{
    BuildRequestAttributeRestrictionsNestedImpl(BuildRequest item) {
      this.builder = new BuildRequestBuilder(this, item);
    }
    BuildRequestAttributeRestrictionsNestedImpl() {
      this.builder = new BuildRequestBuilder(this);
    }
    BuildRequestBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endBuildRequestAttributeRestrictions() {
      return and();
    }
    
  }
  class EgressNetworkPolicyAttributeRestrictionsNestedImpl<N> extends EgressNetworkPolicyFluentImpl<PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<N>> implements PolicyRuleFluent.EgressNetworkPolicyAttributeRestrictionsNested<N>,Nested<N>{
    EgressNetworkPolicyAttributeRestrictionsNestedImpl(EgressNetworkPolicy item) {
      this.builder = new EgressNetworkPolicyBuilder(this, item);
    }
    EgressNetworkPolicyAttributeRestrictionsNestedImpl() {
      this.builder = new EgressNetworkPolicyBuilder(this);
    }
    EgressNetworkPolicyBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endEgressNetworkPolicyAttributeRestrictions() {
      return and();
    }
    
  }
  class NetNamespaceAttributeRestrictionsNestedImpl<N> extends NetNamespaceFluentImpl<PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>> implements PolicyRuleFluent.NetNamespaceAttributeRestrictionsNested<N>,Nested<N>{
    NetNamespaceAttributeRestrictionsNestedImpl(NetNamespace item) {
      this.builder = new NetNamespaceBuilder(this, item);
    }
    NetNamespaceAttributeRestrictionsNestedImpl() {
      this.builder = new NetNamespaceBuilder(this);
    }
    NetNamespaceBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endNetNamespaceAttributeRestrictions() {
      return and();
    }
    
  }
  class UserIdentityMappingAttributeRestrictionsNestedImpl<N> extends UserIdentityMappingFluentImpl<PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<N>> implements PolicyRuleFluent.UserIdentityMappingAttributeRestrictionsNested<N>,Nested<N>{
    UserIdentityMappingAttributeRestrictionsNestedImpl(UserIdentityMapping item) {
      this.builder = new UserIdentityMappingBuilder(this, item);
    }
    UserIdentityMappingAttributeRestrictionsNestedImpl() {
      this.builder = new UserIdentityMappingBuilder(this);
    }
    UserIdentityMappingBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endUserIdentityMappingAttributeRestrictions() {
      return and();
    }
    
  }
  class ImageStreamAttributeRestrictionsNestedImpl<N> extends ImageStreamFluentImpl<PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>> implements PolicyRuleFluent.ImageStreamAttributeRestrictionsNested<N>,Nested<N>{
    ImageStreamAttributeRestrictionsNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImageStreamAttributeRestrictionsNestedImpl() {
      this.builder = new ImageStreamBuilder(this);
    }
    ImageStreamBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endImageStreamAttributeRestrictions() {
      return and();
    }
    
  }
  class OAuthClientAttributeRestrictionsNestedImpl<N> extends OAuthClientFluentImpl<PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>> implements PolicyRuleFluent.OAuthClientAttributeRestrictionsNested<N>,Nested<N>{
    OAuthClientAttributeRestrictionsNestedImpl(OAuthClient item) {
      this.builder = new OAuthClientBuilder(this, item);
    }
    OAuthClientAttributeRestrictionsNestedImpl() {
      this.builder = new OAuthClientBuilder(this);
    }
    OAuthClientBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endOAuthClientAttributeRestrictions() {
      return and();
    }
    
  }
  class IdentityAttributeRestrictionsNestedImpl<N> extends IdentityFluentImpl<PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>> implements PolicyRuleFluent.IdentityAttributeRestrictionsNested<N>,Nested<N>{
    IdentityAttributeRestrictionsNestedImpl(Identity item) {
      this.builder = new IdentityBuilder(this, item);
    }
    IdentityAttributeRestrictionsNestedImpl() {
      this.builder = new IdentityBuilder(this);
    }
    IdentityBuilder builder;
    public N and() {
      return (N) PolicyRuleFluentImpl.this.withAttributeRestrictions(builder.build());
    }
    public N endIdentityAttributeRestrictions() {
      return and();
    }
    
  }
  
}