package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicyReviewBuilder extends PodSecurityPolicyReviewFluentImpl<PodSecurityPolicyReviewBuilder> implements VisitableBuilder<PodSecurityPolicyReview,PodSecurityPolicyReviewBuilder>{
  public PodSecurityPolicyReviewBuilder() {
    this(false);
  }
  public PodSecurityPolicyReviewBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicyReview(), validationEnabled);
  }
  public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicyReview(), validationEnabled);
  }
  public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReviewFluent<?> fluent,PodSecurityPolicyReview instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReviewFluent<?> fluent,PodSecurityPolicyReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReview instance) {
    this(instance,false);
  }
  public PodSecurityPolicyReviewBuilder(PodSecurityPolicyReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PodSecurityPolicyReviewFluent<?> fluent;
  Boolean validationEnabled;
  public PodSecurityPolicyReview build() {
    PodSecurityPolicyReview buildable = new PodSecurityPolicyReview(fluent.getApiVersion(),fluent.getKind(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}