package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface OAuthClientFluent<A extends OAuthClientFluent<A>> extends Fluent<A>{
  public Integer getAccessTokenInactivityTimeoutSeconds();
  public A withAccessTokenInactivityTimeoutSeconds(Integer accessTokenInactivityTimeoutSeconds);
  public Boolean hasAccessTokenInactivityTimeoutSeconds();
  public Integer getAccessTokenMaxAgeSeconds();
  public A withAccessTokenMaxAgeSeconds(Integer accessTokenMaxAgeSeconds);
  public Boolean hasAccessTokenMaxAgeSeconds();
  public A addToAdditionalSecrets(Integer index,String item);
  public A setToAdditionalSecrets(Integer index,String item);
  public A addToAdditionalSecrets(java.lang.String... items);
  public A addAllToAdditionalSecrets(Collection<String> items);
  public A removeFromAdditionalSecrets(java.lang.String... items);
  public A removeAllFromAdditionalSecrets(Collection<String> items);
  public List<String> getAdditionalSecrets();
  public String getAdditionalSecret(Integer index);
  public String getFirstAdditionalSecret();
  public String getLastAdditionalSecret();
  public String getMatchingAdditionalSecret(Predicate<String> predicate);
  public Boolean hasMatchingAdditionalSecret(Predicate<String> predicate);
  public A withAdditionalSecrets(List<String> additionalSecrets);
  public A withAdditionalSecrets(java.lang.String... additionalSecrets);
  public Boolean hasAdditionalSecrets();
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getGrantMethod();
  public A withGrantMethod(String grantMethod);
  public Boolean hasGrantMethod();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public OAuthClientFluent.MetadataNested<A> withNewMetadata();
  public OAuthClientFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public OAuthClientFluent.MetadataNested<A> editMetadata();
  public OAuthClientFluent.MetadataNested<A> editOrNewMetadata();
  public OAuthClientFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  public A addToRedirectURIs(Integer index,String item);
  public A setToRedirectURIs(Integer index,String item);
  public A addToRedirectURIs(java.lang.String... items);
  public A addAllToRedirectURIs(Collection<String> items);
  public A removeFromRedirectURIs(java.lang.String... items);
  public A removeAllFromRedirectURIs(Collection<String> items);
  public List<String> getRedirectURIs();
  public String getRedirectURI(Integer index);
  public String getFirstRedirectURI();
  public String getLastRedirectURI();
  public String getMatchingRedirectURI(Predicate<String> predicate);
  public Boolean hasMatchingRedirectURI(Predicate<String> predicate);
  public A withRedirectURIs(List<String> redirectURIs);
  public A withRedirectURIs(java.lang.String... redirectURIs);
  public Boolean hasRedirectURIs();
  public Boolean getRespondWithChallenges();
  public A withRespondWithChallenges(Boolean respondWithChallenges);
  public Boolean hasRespondWithChallenges();
  public A addToScopeRestrictions(Integer index,ScopeRestriction item);
  public A setToScopeRestrictions(Integer index,ScopeRestriction item);
  public A addToScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items);
  public A addAllToScopeRestrictions(Collection<ScopeRestriction> items);
  public A removeFromScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... items);
  public A removeAllFromScopeRestrictions(Collection<ScopeRestriction> items);
  public A removeMatchingFromScopeRestrictions(Predicate<ScopeRestrictionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildScopeRestrictions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ScopeRestriction> getScopeRestrictions();
  public List<ScopeRestriction> buildScopeRestrictions();
  public ScopeRestriction buildScopeRestriction(Integer index);
  public ScopeRestriction buildFirstScopeRestriction();
  public ScopeRestriction buildLastScopeRestriction();
  public ScopeRestriction buildMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate);
  public Boolean hasMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate);
  public A withScopeRestrictions(List<ScopeRestriction> scopeRestrictions);
  public A withScopeRestrictions(io.fabric8.openshift.api.model.ScopeRestriction... scopeRestrictions);
  public Boolean hasScopeRestrictions();
  public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction();
  public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(ScopeRestriction item);
  public OAuthClientFluent.ScopeRestrictionsNested<A> setNewScopeRestrictionLike(Integer index,ScopeRestriction item);
  public OAuthClientFluent.ScopeRestrictionsNested<A> editScopeRestriction(Integer index);
  public OAuthClientFluent.ScopeRestrictionsNested<A> editFirstScopeRestriction();
  public OAuthClientFluent.ScopeRestrictionsNested<A> editLastScopeRestriction();
  public OAuthClientFluent.ScopeRestrictionsNested<A> editMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate);
  public String getSecret();
  public A withSecret(String secret);
  public Boolean hasSecret();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withRespondWithChallenges();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<OAuthClientFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface ScopeRestrictionsNested<N> extends Nested<N>,ScopeRestrictionFluent<OAuthClientFluent.ScopeRestrictionsNested<N>>{
    public N and();
    public N endScopeRestriction();
    
  }
  
}