package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetNamespaceListBuilder extends NetNamespaceListFluentImpl<NetNamespaceListBuilder> implements VisitableBuilder<NetNamespaceList,NetNamespaceListBuilder>{
  public NetNamespaceListBuilder() {
    this(false);
  }
  public NetNamespaceListBuilder(Boolean validationEnabled) {
    this(new NetNamespaceList(), validationEnabled);
  }
  public NetNamespaceListBuilder(NetNamespaceListFluent<?> fluent) {
    this(fluent, false);
  }
  public NetNamespaceListBuilder(NetNamespaceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetNamespaceList(), validationEnabled);
  }
  public NetNamespaceListBuilder(NetNamespaceListFluent<?> fluent,NetNamespaceList instance) {
    this(fluent, instance, false);
  }
  public NetNamespaceListBuilder(NetNamespaceListFluent<?> fluent,NetNamespaceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetNamespaceListBuilder(NetNamespaceList instance) {
    this(instance,false);
  }
  public NetNamespaceListBuilder(NetNamespaceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NetNamespaceListFluent<?> fluent;
  Boolean validationEnabled;
  public NetNamespaceList build() {
    NetNamespaceList buildable = new NetNamespaceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}