package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageStreamImportStatusFluentImpl<A extends ImageStreamImportStatusFluent<A>> extends BaseFluent<A> implements ImageStreamImportStatusFluent<A>{
  public ImageStreamImportStatusFluentImpl() {
  }
  public ImageStreamImportStatusFluentImpl(ImageStreamImportStatus instance) {
    this.withImages(instance.getImages()); 
    this.withImport(instance.getImport()); 
    this.withRepository(instance.getRepository()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ImageImportStatusBuilder> images = new ArrayList<ImageImportStatusBuilder>();
  private ImageStreamBuilder _import;
  private RepositoryImportStatusBuilder repository;
  private Map<String,Object> additionalProperties;
  public A addToImages(Integer index,ImageImportStatus item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").add(index >= 0 ? index : _visitables.get("images").size(), builder);this.images.add(index >= 0 ? index : images.size(), builder); return (A)this;
  }
  public A setToImages(Integer index,ImageImportStatus item) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
    if (index < 0 || index >= _visitables.get("images").size()) { _visitables.get("images").add(builder); } else { _visitables.get("images").set(index, builder);}
    if (index < 0 || index >= images.size()) { images.add(builder); } else { images.set(index, builder);}
     return (A)this;
  }
  public A addToImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A addAllToImages(Collection<ImageImportStatus> items) {
    if (this.images == null) {this.images = new ArrayList<ImageImportStatusBuilder>();}
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").add(builder);this.images.add(builder);} return (A)this;
  }
  public A removeFromImages(io.fabric8.openshift.api.model.ImageImportStatus... items) {
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeAllFromImages(Collection<ImageImportStatus> items) {
    for (ImageImportStatus item : items) {ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);_visitables.get("images").remove(builder);if (this.images != null) {this.images.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromImages(Predicate<ImageImportStatusBuilder> predicate) {
    if (images == null) return (A) this;
    final Iterator<ImageImportStatusBuilder> each = images.iterator();
    final List visitables = _visitables.get("images");
    while (each.hasNext()) {
      ImageImportStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildImages instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ImageImportStatus> getImages() {
    return images != null ? build(images) : null;
  }
  public List<ImageImportStatus> buildImages() {
    return images != null ? build(images) : null;
  }
  public ImageImportStatus buildImage(Integer index) {
    return this.images.get(index).build();
  }
  public ImageImportStatus buildFirstImage() {
    return this.images.get(0).build();
  }
  public ImageImportStatus buildLastImage() {
    return this.images.get(images.size() - 1).build();
  }
  public ImageImportStatus buildMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    for (ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    for (ImageImportStatusBuilder item: images) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withImages(List<ImageImportStatus> images) {
    if (this.images != null) { _visitables.get("images").removeAll(this.images);}
    if (images != null) {this.images = new ArrayList(); for (ImageImportStatus item : images){this.addToImages(item);}} else { this.images = null;} return (A) this;
  }
  public A withImages(io.fabric8.openshift.api.model.ImageImportStatus... images) {
    if (this.images != null) {this.images.clear();}
    if (images != null) {for (ImageImportStatus item :images){ this.addToImages(item);}} return (A) this;
  }
  public Boolean hasImages() {
    return images != null && !images.isEmpty();
  }
  public ImageStreamImportStatusFluent.ImagesNested<A> addNewImage() {
    return new ImageStreamImportStatusFluentImpl.ImagesNestedImpl();
  }
  public ImageStreamImportStatusFluent.ImagesNested<A> addNewImageLike(ImageImportStatus item) {
    return new ImageStreamImportStatusFluentImpl.ImagesNestedImpl(-1, item);
  }
  public ImageStreamImportStatusFluent.ImagesNested<A> setNewImageLike(Integer index,ImageImportStatus item) {
    return new ImageStreamImportStatusFluentImpl.ImagesNestedImpl(index, item);
  }
  public ImageStreamImportStatusFluent.ImagesNested<A> editImage(Integer index) {
    if (images.size() <= index) throw new RuntimeException("Can't edit images. Index exceeds size.");
    return setNewImageLike(index, buildImage(index));
  }
  public ImageStreamImportStatusFluent.ImagesNested<A> editFirstImage() {
    if (images.size() == 0) throw new RuntimeException("Can't edit first images. The list is empty.");
    return setNewImageLike(0, buildImage(0));
  }
  public ImageStreamImportStatusFluent.ImagesNested<A> editLastImage() {
    int index = images.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last images. The list is empty.");
    return setNewImageLike(index, buildImage(index));
  }
  public ImageStreamImportStatusFluent.ImagesNested<A> editMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<images.size();i++) { 
    if (predicate.test(images.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching images. No match found.");
    return setNewImageLike(index, buildImage(index));
  }
  
  /**
   * This method has been deprecated, please use method buildImport instead.
   * @return The buildable object.
   */
  @Deprecated
  public ImageStream getImport() {
    return this._import!=null ?this._import.build():null;
  }
  public ImageStream buildImport() {
    return this._import!=null ?this._import.build():null;
  }
  public A withImport(ImageStream _import) {
    _visitables.get("_import").remove(this._import);
    if (_import!=null){ this._import= new ImageStreamBuilder(_import); _visitables.get("_import").add(this._import);} else { this._import = null; _visitables.get("_import").remove(this._import); } return (A) this;
  }
  public Boolean hasImport() {
    return this._import != null;
  }
  public ImageStreamImportStatusFluent.ImportNested<A> withNewImport() {
    return new ImageStreamImportStatusFluentImpl.ImportNestedImpl();
  }
  public ImageStreamImportStatusFluent.ImportNested<A> withNewImportLike(ImageStream item) {
    return new ImageStreamImportStatusFluentImpl.ImportNestedImpl(item);
  }
  public ImageStreamImportStatusFluent.ImportNested<A> editImport() {
    return withNewImportLike(getImport());
  }
  public ImageStreamImportStatusFluent.ImportNested<A> editOrNewImport() {
    return withNewImportLike(getImport() != null ? getImport(): new ImageStreamBuilder().build());
  }
  public ImageStreamImportStatusFluent.ImportNested<A> editOrNewImportLike(ImageStream item) {
    return withNewImportLike(getImport() != null ? getImport(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRepository instead.
   * @return The buildable object.
   */
  @Deprecated
  public RepositoryImportStatus getRepository() {
    return this.repository!=null ?this.repository.build():null;
  }
  public RepositoryImportStatus buildRepository() {
    return this.repository!=null ?this.repository.build():null;
  }
  public A withRepository(RepositoryImportStatus repository) {
    _visitables.get("repository").remove(this.repository);
    if (repository!=null){ this.repository= new RepositoryImportStatusBuilder(repository); _visitables.get("repository").add(this.repository);} else { this.repository = null; _visitables.get("repository").remove(this.repository); } return (A) this;
  }
  public Boolean hasRepository() {
    return this.repository != null;
  }
  public ImageStreamImportStatusFluent.RepositoryNested<A> withNewRepository() {
    return new ImageStreamImportStatusFluentImpl.RepositoryNestedImpl();
  }
  public ImageStreamImportStatusFluent.RepositoryNested<A> withNewRepositoryLike(RepositoryImportStatus item) {
    return new ImageStreamImportStatusFluentImpl.RepositoryNestedImpl(item);
  }
  public ImageStreamImportStatusFluent.RepositoryNested<A> editRepository() {
    return withNewRepositoryLike(getRepository());
  }
  public ImageStreamImportStatusFluent.RepositoryNested<A> editOrNewRepository() {
    return withNewRepositoryLike(getRepository() != null ? getRepository(): new RepositoryImportStatusBuilder().build());
  }
  public ImageStreamImportStatusFluent.RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportStatus item) {
    return withNewRepositoryLike(getRepository() != null ? getRepository(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageStreamImportStatusFluentImpl that = (ImageStreamImportStatusFluentImpl) o;
    if (images != null ? !images.equals(that.images) :that.images != null) return false;
    if (_import != null ? !_import.equals(that._import) :that._import != null) return false;
    if (repository != null ? !repository.equals(that.repository) :that.repository != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(images,  _import,  repository,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (images != null && !images.isEmpty()) { sb.append("images:"); sb.append(images + ","); }
    if (_import != null) { sb.append("_import:"); sb.append(_import + ","); }
    if (repository != null) { sb.append("repository:"); sb.append(repository + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImagesNestedImpl<N> extends ImageImportStatusFluentImpl<ImageStreamImportStatusFluent.ImagesNested<N>> implements ImageStreamImportStatusFluent.ImagesNested<N>,Nested<N>{
    ImagesNestedImpl(Integer index,ImageImportStatus item) {
      this.index = index;
      this.builder = new ImageImportStatusBuilder(this, item);
    }
    ImagesNestedImpl() {
      this.index = -1;
      this.builder = new ImageImportStatusBuilder(this);
    }
    ImageImportStatusBuilder builder;
    Integer index;
    public N and() {
      return (N) ImageStreamImportStatusFluentImpl.this.setToImages(index,builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class ImportNestedImpl<N> extends ImageStreamFluentImpl<ImageStreamImportStatusFluent.ImportNested<N>> implements ImageStreamImportStatusFluent.ImportNested<N>,Nested<N>{
    ImportNestedImpl(ImageStream item) {
      this.builder = new ImageStreamBuilder(this, item);
    }
    ImportNestedImpl() {
      this.builder = new ImageStreamBuilder(this);
    }
    ImageStreamBuilder builder;
    public N and() {
      return (N) ImageStreamImportStatusFluentImpl.this.withImport(builder.build());
    }
    public N endImport() {
      return and();
    }
    
  }
  class RepositoryNestedImpl<N> extends RepositoryImportStatusFluentImpl<ImageStreamImportStatusFluent.RepositoryNested<N>> implements ImageStreamImportStatusFluent.RepositoryNested<N>,Nested<N>{
    RepositoryNestedImpl(RepositoryImportStatus item) {
      this.builder = new RepositoryImportStatusBuilder(this, item);
    }
    RepositoryNestedImpl() {
      this.builder = new RepositoryImportStatusBuilder(this);
    }
    RepositoryImportStatusBuilder builder;
    public N and() {
      return (N) ImageStreamImportStatusFluentImpl.this.withRepository(builder.build());
    }
    public N endRepository() {
      return and();
    }
    
  }
  
}