package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmChartRepositoryStatusBuilder extends HelmChartRepositoryStatusFluentImpl<HelmChartRepositoryStatusBuilder> implements VisitableBuilder<HelmChartRepositoryStatus,HelmChartRepositoryStatusBuilder>{
  public HelmChartRepositoryStatusBuilder() {
    this(false);
  }
  public HelmChartRepositoryStatusBuilder(Boolean validationEnabled) {
    this(new HelmChartRepositoryStatus(), validationEnabled);
  }
  public HelmChartRepositoryStatusBuilder(HelmChartRepositoryStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmChartRepositoryStatusBuilder(HelmChartRepositoryStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HelmChartRepositoryStatus(), validationEnabled);
  }
  public HelmChartRepositoryStatusBuilder(HelmChartRepositoryStatusFluent<?> fluent,HelmChartRepositoryStatus instance) {
    this(fluent, instance, false);
  }
  public HelmChartRepositoryStatusBuilder(HelmChartRepositoryStatusFluent<?> fluent,HelmChartRepositoryStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HelmChartRepositoryStatusBuilder(HelmChartRepositoryStatus instance) {
    this(instance,false);
  }
  public HelmChartRepositoryStatusBuilder(HelmChartRepositoryStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HelmChartRepositoryStatusFluent<?> fluent;
  Boolean validationEnabled;
  public HelmChartRepositoryStatus build() {
    HelmChartRepositoryStatus buildable = new HelmChartRepositoryStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}