package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentCauseBuilder extends DeploymentCauseFluentImpl<DeploymentCauseBuilder> implements VisitableBuilder<DeploymentCause,DeploymentCauseBuilder>{
  public DeploymentCauseBuilder() {
    this(false);
  }
  public DeploymentCauseBuilder(Boolean validationEnabled) {
    this(new DeploymentCause(), validationEnabled);
  }
  public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentCause(), validationEnabled);
  }
  public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent,DeploymentCause instance) {
    this(fluent, instance, false);
  }
  public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent,DeploymentCause instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImageTrigger(instance.getImageTrigger()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentCauseBuilder(DeploymentCause instance) {
    this(instance,false);
  }
  public DeploymentCauseBuilder(DeploymentCause instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withImageTrigger(instance.getImageTrigger()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  DeploymentCauseFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentCause build() {
    DeploymentCause buildable = new DeploymentCause(fluent.getImageTrigger(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}