package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ConfigMapBuildSourceFluentImpl<A extends ConfigMapBuildSourceFluent<A>> extends BaseFluent<A> implements ConfigMapBuildSourceFluent<A>{
  public ConfigMapBuildSourceFluentImpl() {
  }
  public ConfigMapBuildSourceFluentImpl(ConfigMapBuildSource instance) {
    this.withConfigMap(instance.getConfigMap()); 
    this.withDestinationDir(instance.getDestinationDir()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private LocalObjectReferenceBuilder configMap;
  private String destinationDir;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildConfigMap instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public LocalObjectReference buildConfigMap() {
    return this.configMap!=null ?this.configMap.build():null;
  }
  public A withConfigMap(LocalObjectReference configMap) {
    _visitables.get("configMap").remove(this.configMap);
    if (configMap!=null){ this.configMap= new LocalObjectReferenceBuilder(configMap); _visitables.get("configMap").add(this.configMap);} else { this.configMap = null; _visitables.get("configMap").remove(this.configMap); } return (A) this;
  }
  public Boolean hasConfigMap() {
    return this.configMap != null;
  }
  public A withNewConfigMap(String name) {
    return (A)withConfigMap(new LocalObjectReference(name));
  }
  public ConfigMapBuildSourceFluent.ConfigMapNested<A> withNewConfigMap() {
    return new ConfigMapBuildSourceFluentImpl.ConfigMapNestedImpl();
  }
  public ConfigMapBuildSourceFluent.ConfigMapNested<A> withNewConfigMapLike(LocalObjectReference item) {
    return new ConfigMapBuildSourceFluentImpl.ConfigMapNestedImpl(item);
  }
  public ConfigMapBuildSourceFluent.ConfigMapNested<A> editConfigMap() {
    return withNewConfigMapLike(getConfigMap());
  }
  public ConfigMapBuildSourceFluent.ConfigMapNested<A> editOrNewConfigMap() {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): new LocalObjectReferenceBuilder().build());
  }
  public ConfigMapBuildSourceFluent.ConfigMapNested<A> editOrNewConfigMapLike(LocalObjectReference item) {
    return withNewConfigMapLike(getConfigMap() != null ? getConfigMap(): item);
  }
  public String getDestinationDir() {
    return this.destinationDir;
  }
  public A withDestinationDir(String destinationDir) {
    this.destinationDir=destinationDir; return (A) this;
  }
  public Boolean hasDestinationDir() {
    return this.destinationDir != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigMapBuildSourceFluentImpl that = (ConfigMapBuildSourceFluentImpl) o;
    if (configMap != null ? !configMap.equals(that.configMap) :that.configMap != null) return false;
    if (destinationDir != null ? !destinationDir.equals(that.destinationDir) :that.destinationDir != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(configMap,  destinationDir,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (destinationDir != null) { sb.append("destinationDir:"); sb.append(destinationDir + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConfigMapNestedImpl<N> extends LocalObjectReferenceFluentImpl<ConfigMapBuildSourceFluent.ConfigMapNested<N>> implements ConfigMapBuildSourceFluent.ConfigMapNested<N>,Nested<N>{
    ConfigMapNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ConfigMapNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ConfigMapBuildSourceFluentImpl.this.withConfigMap(builder.build());
    }
    public N endConfigMap() {
      return and();
    }
    
  }
  
}