package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleScopeRestrictionBuilder extends ClusterRoleScopeRestrictionFluentImpl<ClusterRoleScopeRestrictionBuilder> implements VisitableBuilder<ClusterRoleScopeRestriction,ClusterRoleScopeRestrictionBuilder>{
  public ClusterRoleScopeRestrictionBuilder() {
    this(false);
  }
  public ClusterRoleScopeRestrictionBuilder(Boolean validationEnabled) {
    this(new ClusterRoleScopeRestriction(), validationEnabled);
  }
  public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestrictionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestrictionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRoleScopeRestriction(), validationEnabled);
  }
  public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestrictionFluent<?> fluent,ClusterRoleScopeRestriction instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestrictionFluent<?> fluent,ClusterRoleScopeRestriction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllowEscalation(instance.getAllowEscalation()); 
    fluent.withNamespaces(instance.getNamespaces()); 
    fluent.withRoleNames(instance.getRoleNames()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestriction instance) {
    this(instance,false);
  }
  public ClusterRoleScopeRestrictionBuilder(ClusterRoleScopeRestriction instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllowEscalation(instance.getAllowEscalation()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withRoleNames(instance.getRoleNames()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterRoleScopeRestrictionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRoleScopeRestriction build() {
    ClusterRoleScopeRestriction buildable = new ClusterRoleScopeRestriction(fluent.getAllowEscalation(),fluent.getNamespaces(),fluent.getRoleNames());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}