package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRoleBindingListBuilder extends ClusterRoleBindingListFluentImpl<ClusterRoleBindingListBuilder> implements VisitableBuilder<ClusterRoleBindingList,ClusterRoleBindingListBuilder>{
  public ClusterRoleBindingListBuilder() {
    this(false);
  }
  public ClusterRoleBindingListBuilder(Boolean validationEnabled) {
    this(new ClusterRoleBindingList(), validationEnabled);
  }
  public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRoleBindingList(), validationEnabled);
  }
  public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent,ClusterRoleBindingList instance) {
    this(fluent, instance, false);
  }
  public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent,ClusterRoleBindingList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRoleBindingListBuilder(ClusterRoleBindingList instance) {
    this(instance,false);
  }
  public ClusterRoleBindingListBuilder(ClusterRoleBindingList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterRoleBindingListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRoleBindingList build() {
    ClusterRoleBindingList buildable = new ClusterRoleBindingList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}