package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WebhookTokenAuthenticatorBuilder extends WebhookTokenAuthenticatorFluentImpl<WebhookTokenAuthenticatorBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.WebhookTokenAuthenticator,io.fabric8.openshift.api.model.WebhookTokenAuthenticatorBuilder>{
  public WebhookTokenAuthenticatorBuilder() {
    this(false);
  }
  public WebhookTokenAuthenticatorBuilder(Boolean validationEnabled) {
    this(new WebhookTokenAuthenticator(), validationEnabled);
  }
  public WebhookTokenAuthenticatorBuilder(WebhookTokenAuthenticatorFluent<?> fluent) {
    this(fluent, false);
  }
  public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new WebhookTokenAuthenticator(), validationEnabled);
  }
  public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluent<?> fluent,io.fabric8.openshift.api.model.WebhookTokenAuthenticator instance) {
    this(fluent, instance, false);
  }
  public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluent<?> fluent,io.fabric8.openshift.api.model.WebhookTokenAuthenticator instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKubeConfig(instance.getKubeConfig()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticator instance) {
    this(instance,false);
  }
  public WebhookTokenAuthenticatorBuilder(io.fabric8.openshift.api.model.WebhookTokenAuthenticator instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withKubeConfig(instance.getKubeConfig()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.WebhookTokenAuthenticatorFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.WebhookTokenAuthenticator build() {
    WebhookTokenAuthenticator buildable = new WebhookTokenAuthenticator(fluent.getKubeConfig());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}