package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UpdateBuilder extends UpdateFluentImpl<UpdateBuilder> implements VisitableBuilder<Update,io.fabric8.openshift.api.model.UpdateBuilder>{
  public UpdateBuilder() {
    this(false);
  }
  public UpdateBuilder(Boolean validationEnabled) {
    this(new Update(), validationEnabled);
  }
  public UpdateBuilder(io.fabric8.openshift.api.model.UpdateFluent<?> fluent) {
    this(fluent, false);
  }
  public UpdateBuilder(io.fabric8.openshift.api.model.UpdateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Update(), validationEnabled);
  }
  public UpdateBuilder(io.fabric8.openshift.api.model.UpdateFluent<?> fluent,io.fabric8.openshift.api.model.Update instance) {
    this(fluent, instance, false);
  }
  public UpdateBuilder(io.fabric8.openshift.api.model.UpdateFluent<?> fluent,io.fabric8.openshift.api.model.Update instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withForce(instance.getForce()); 
    fluent.withImage(instance.getImage()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UpdateBuilder(io.fabric8.openshift.api.model.Update instance) {
    this(instance,false);
  }
  public UpdateBuilder(io.fabric8.openshift.api.model.Update instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withForce(instance.getForce()); 
    this.withImage(instance.getImage()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.UpdateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Update build() {
    Update buildable = new Update(fluent.getForce(),fluent.getImage(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}