package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateInstanceSpecBuilder extends TemplateInstanceSpecFluentImpl<TemplateInstanceSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.TemplateInstanceSpec,TemplateInstanceSpecBuilder>{
  public TemplateInstanceSpecBuilder() {
    this(false);
  }
  public TemplateInstanceSpecBuilder(Boolean validationEnabled) {
    this(new TemplateInstanceSpec(), validationEnabled);
  }
  public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TemplateInstanceSpec(), validationEnabled);
  }
  public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent,io.fabric8.openshift.api.model.TemplateInstanceSpec instance) {
    this(fluent, instance, false);
  }
  public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent,io.fabric8.openshift.api.model.TemplateInstanceSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRequester(instance.getRequester()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpec instance) {
    this(instance,false);
  }
  public TemplateInstanceSpecBuilder(io.fabric8.openshift.api.model.TemplateInstanceSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRequester(instance.getRequester()); 
    this.withSecret(instance.getSecret()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.TemplateInstanceSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.TemplateInstanceSpec build() {
    TemplateInstanceSpec buildable = new TemplateInstanceSpec(fluent.getRequester(),fluent.getSecret(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}