package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TemplateInstanceConditionBuilder extends TemplateInstanceConditionFluentImpl<TemplateInstanceConditionBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.TemplateInstanceCondition,TemplateInstanceConditionBuilder>{
  public TemplateInstanceConditionBuilder() {
    this(false);
  }
  public TemplateInstanceConditionBuilder(Boolean validationEnabled) {
    this(new TemplateInstanceCondition(), validationEnabled);
  }
  public TemplateInstanceConditionBuilder(TemplateInstanceConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public TemplateInstanceConditionBuilder(io.fabric8.openshift.api.model.TemplateInstanceConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TemplateInstanceCondition(), validationEnabled);
  }
  public TemplateInstanceConditionBuilder(io.fabric8.openshift.api.model.TemplateInstanceConditionFluent<?> fluent,io.fabric8.openshift.api.model.TemplateInstanceCondition instance) {
    this(fluent, instance, false);
  }
  public TemplateInstanceConditionBuilder(io.fabric8.openshift.api.model.TemplateInstanceConditionFluent<?> fluent,io.fabric8.openshift.api.model.TemplateInstanceCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TemplateInstanceConditionBuilder(io.fabric8.openshift.api.model.TemplateInstanceCondition instance) {
    this(instance,false);
  }
  public TemplateInstanceConditionBuilder(io.fabric8.openshift.api.model.TemplateInstanceCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.TemplateInstanceConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.TemplateInstanceCondition build() {
    TemplateInstanceCondition buildable = new TemplateInstanceCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}