package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TagEventBuilder extends TagEventFluentImpl<TagEventBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.TagEvent,TagEventBuilder>{
  public TagEventBuilder() {
    this(false);
  }
  public TagEventBuilder(Boolean validationEnabled) {
    this(new TagEvent(), validationEnabled);
  }
  public TagEventBuilder(TagEventFluent<?> fluent) {
    this(fluent, false);
  }
  public TagEventBuilder(io.fabric8.openshift.api.model.TagEventFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new TagEvent(), validationEnabled);
  }
  public TagEventBuilder(io.fabric8.openshift.api.model.TagEventFluent<?> fluent,io.fabric8.openshift.api.model.TagEvent instance) {
    this(fluent, instance, false);
  }
  public TagEventBuilder(io.fabric8.openshift.api.model.TagEventFluent<?> fluent,io.fabric8.openshift.api.model.TagEvent instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCreated(instance.getCreated()); 
    fluent.withDockerImageReference(instance.getDockerImageReference()); 
    fluent.withGeneration(instance.getGeneration()); 
    fluent.withImage(instance.getImage()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public TagEventBuilder(io.fabric8.openshift.api.model.TagEvent instance) {
    this(instance,false);
  }
  public TagEventBuilder(io.fabric8.openshift.api.model.TagEvent instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCreated(instance.getCreated()); 
    this.withDockerImageReference(instance.getDockerImageReference()); 
    this.withGeneration(instance.getGeneration()); 
    this.withImage(instance.getImage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.TagEventFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.TagEvent build() {
    TagEvent buildable = new TagEvent(fluent.getCreated(),fluent.getDockerImageReference(),fluent.getGeneration(),fluent.getImage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}