package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceBuildStrategyBuilder extends SourceBuildStrategyFluentImpl<SourceBuildStrategyBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.SourceBuildStrategy,io.fabric8.openshift.api.model.SourceBuildStrategyBuilder>{
  public SourceBuildStrategyBuilder() {
    this(false);
  }
  public SourceBuildStrategyBuilder(Boolean validationEnabled) {
    this(new SourceBuildStrategy(), validationEnabled);
  }
  public SourceBuildStrategyBuilder(SourceBuildStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceBuildStrategyBuilder(io.fabric8.openshift.api.model.SourceBuildStrategyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SourceBuildStrategy(), validationEnabled);
  }
  public SourceBuildStrategyBuilder(io.fabric8.openshift.api.model.SourceBuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.SourceBuildStrategy instance) {
    this(fluent, instance, false);
  }
  public SourceBuildStrategyBuilder(io.fabric8.openshift.api.model.SourceBuildStrategyFluent<?> fluent,io.fabric8.openshift.api.model.SourceBuildStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEnv(instance.getEnv()); 
    fluent.withForcePull(instance.getForcePull()); 
    fluent.withFrom(instance.getFrom()); 
    fluent.withIncremental(instance.getIncremental()); 
    fluent.withPullSecret(instance.getPullSecret()); 
    fluent.withScripts(instance.getScripts()); 
    fluent.withVolumes(instance.getVolumes()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SourceBuildStrategyBuilder(io.fabric8.openshift.api.model.SourceBuildStrategy instance) {
    this(instance,false);
  }
  public SourceBuildStrategyBuilder(io.fabric8.openshift.api.model.SourceBuildStrategy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEnv(instance.getEnv()); 
    this.withForcePull(instance.getForcePull()); 
    this.withFrom(instance.getFrom()); 
    this.withIncremental(instance.getIncremental()); 
    this.withPullSecret(instance.getPullSecret()); 
    this.withScripts(instance.getScripts()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SourceBuildStrategyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SourceBuildStrategy build() {
    SourceBuildStrategy buildable = new SourceBuildStrategy(fluent.getEnv(),fluent.getForcePull(),fluent.getFrom(),fluent.getIncremental(),fluent.getPullSecret(),fluent.getScripts(),fluent.getVolumes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}