package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceAccountRestrictionFluentImpl<A extends ServiceAccountRestrictionFluent<A>> extends BaseFluent<A> implements ServiceAccountRestrictionFluent<A>{
  public ServiceAccountRestrictionFluentImpl() {
  }
  public ServiceAccountRestrictionFluentImpl(io.fabric8.openshift.api.model.ServiceAccountRestriction instance) {
    this.withNamespaces(instance.getNamespaces()); 
    this.withServiceaccounts(instance.getServiceaccounts()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> namespaces = new ArrayList<java.lang.String>();
  private java.util.ArrayList<ServiceAccountReferenceBuilder> serviceaccounts = new java.util.ArrayList<ServiceAccountReferenceBuilder>();
  private Map<java.lang.String,Object> additionalProperties;
  public A addToNamespaces(Integer index,java.lang.String item) {
    if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
    this.namespaces.add(index, item);
    return (A)this;
  }
  public A setToNamespaces(java.lang.Integer index,java.lang.String item) {
    if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
    this.namespaces.set(index, item); return (A)this;
  }
  public A addToNamespaces(java.lang.String... items) {
    if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A addAllToNamespaces(Collection<java.lang.String> items) {
    if (this.namespaces == null) {this.namespaces = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.namespaces.add(item);} return (A)this;
  }
  public A removeFromNamespaces(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
  }
  public A removeAllFromNamespaces(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.namespaces!= null){ this.namespaces.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getNamespaces() {
    return this.namespaces;
  }
  public java.lang.String getNamespace(java.lang.Integer index) {
    return this.namespaces.get(index);
  }
  public java.lang.String getFirstNamespace() {
    return this.namespaces.get(0);
  }
  public java.lang.String getLastNamespace() {
    return this.namespaces.get(namespaces.size() - 1);
  }
  public java.lang.String getMatchingNamespace(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: namespaces) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNamespace(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: namespaces) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNamespaces(java.util.List<java.lang.String> namespaces) {
    if (namespaces != null) {this.namespaces = new java.util.ArrayList(); for (java.lang.String item : namespaces){this.addToNamespaces(item);}} else { this.namespaces = null;} return (A) this;
  }
  public A withNamespaces(java.lang.String... namespaces) {
    if (this.namespaces != null) {this.namespaces.clear();}
    if (namespaces != null) {for (java.lang.String item :namespaces){ this.addToNamespaces(item);}} return (A) this;
  }
  public java.lang.Boolean hasNamespaces() {
    return namespaces != null && !namespaces.isEmpty();
  }
  public A addToServiceaccounts(java.lang.Integer index,io.fabric8.openshift.api.model.ServiceAccountReference item) {
    if (this.serviceaccounts == null) {this.serviceaccounts = new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder>();}
    io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder(item);_visitables.get("serviceaccounts").add(index >= 0 ? index : _visitables.get("serviceaccounts").size(), builder);this.serviceaccounts.add(index >= 0 ? index : serviceaccounts.size(), builder); return (A)this;
  }
  public A setToServiceaccounts(java.lang.Integer index,io.fabric8.openshift.api.model.ServiceAccountReference item) {
    if (this.serviceaccounts == null) {this.serviceaccounts = new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder>();}
    io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder(item);
    if (index < 0 || index >= _visitables.get("serviceaccounts").size()) { _visitables.get("serviceaccounts").add(builder); } else { _visitables.get("serviceaccounts").set(index, builder);}
    if (index < 0 || index >= serviceaccounts.size()) { serviceaccounts.add(builder); } else { serviceaccounts.set(index, builder);}
     return (A)this;
  }
  public A addToServiceaccounts(io.fabric8.openshift.api.model.ServiceAccountReference... items) {
    if (this.serviceaccounts == null) {this.serviceaccounts = new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder>();}
    for (io.fabric8.openshift.api.model.ServiceAccountReference item : items) {io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder(item);_visitables.get("serviceaccounts").add(builder);this.serviceaccounts.add(builder);} return (A)this;
  }
  public A addAllToServiceaccounts(java.util.Collection<io.fabric8.openshift.api.model.ServiceAccountReference> items) {
    if (this.serviceaccounts == null) {this.serviceaccounts = new java.util.ArrayList<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder>();}
    for (io.fabric8.openshift.api.model.ServiceAccountReference item : items) {io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder(item);_visitables.get("serviceaccounts").add(builder);this.serviceaccounts.add(builder);} return (A)this;
  }
  public A removeFromServiceaccounts(io.fabric8.openshift.api.model.ServiceAccountReference... items) {
    for (io.fabric8.openshift.api.model.ServiceAccountReference item : items) {io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder(item);_visitables.get("serviceaccounts").remove(builder);if (this.serviceaccounts != null) {this.serviceaccounts.remove(builder);}} return (A)this;
  }
  public A removeAllFromServiceaccounts(java.util.Collection<io.fabric8.openshift.api.model.ServiceAccountReference> items) {
    for (io.fabric8.openshift.api.model.ServiceAccountReference item : items) {io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder builder = new io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder(item);_visitables.get("serviceaccounts").remove(builder);if (this.serviceaccounts != null) {this.serviceaccounts.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServiceaccounts(java.util.function.Predicate<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder> predicate) {
    if (serviceaccounts == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder> each = serviceaccounts.iterator();
    final List visitables = _visitables.get("serviceaccounts");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServiceaccounts instead.
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ServiceAccountReference> getServiceaccounts() {
    return serviceaccounts != null ? build(serviceaccounts) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.ServiceAccountReference> buildServiceaccounts() {
    return serviceaccounts != null ? build(serviceaccounts) : null;
  }
  public io.fabric8.openshift.api.model.ServiceAccountReference buildServiceaccount(java.lang.Integer index) {
    return this.serviceaccounts.get(index).build();
  }
  public io.fabric8.openshift.api.model.ServiceAccountReference buildFirstServiceaccount() {
    return this.serviceaccounts.get(0).build();
  }
  public io.fabric8.openshift.api.model.ServiceAccountReference buildLastServiceaccount() {
    return this.serviceaccounts.get(serviceaccounts.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.ServiceAccountReference buildMatchingServiceaccount(java.util.function.Predicate<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder item: serviceaccounts) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingServiceaccount(java.util.function.Predicate<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder> predicate) {
    for (io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder item: serviceaccounts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServiceaccounts(java.util.List<io.fabric8.openshift.api.model.ServiceAccountReference> serviceaccounts) {
    if (this.serviceaccounts != null) { _visitables.get("serviceaccounts").removeAll(this.serviceaccounts);}
    if (serviceaccounts != null) {this.serviceaccounts = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.ServiceAccountReference item : serviceaccounts){this.addToServiceaccounts(item);}} else { this.serviceaccounts = null;} return (A) this;
  }
  public A withServiceaccounts(io.fabric8.openshift.api.model.ServiceAccountReference... serviceaccounts) {
    if (this.serviceaccounts != null) {this.serviceaccounts.clear();}
    if (serviceaccounts != null) {for (io.fabric8.openshift.api.model.ServiceAccountReference item :serviceaccounts){ this.addToServiceaccounts(item);}} return (A) this;
  }
  public java.lang.Boolean hasServiceaccounts() {
    return serviceaccounts != null && !serviceaccounts.isEmpty();
  }
  public A addNewServiceaccount(java.lang.String name,java.lang.String namespace) {
    return (A)addToServiceaccounts(new ServiceAccountReference(name, namespace));
  }
  public ServiceAccountRestrictionFluent.ServiceaccountsNested<A> addNewServiceaccount() {
    return new ServiceAccountRestrictionFluentImpl.ServiceaccountsNestedImpl();
  }
  public io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent.ServiceaccountsNested<A> addNewServiceaccountLike(io.fabric8.openshift.api.model.ServiceAccountReference item) {
    return new ServiceAccountRestrictionFluentImpl.ServiceaccountsNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent.ServiceaccountsNested<A> setNewServiceaccountLike(java.lang.Integer index,io.fabric8.openshift.api.model.ServiceAccountReference item) {
    return new io.fabric8.openshift.api.model.ServiceAccountRestrictionFluentImpl.ServiceaccountsNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent.ServiceaccountsNested<A> editServiceaccount(java.lang.Integer index) {
    if (serviceaccounts.size() <= index) throw new RuntimeException("Can't edit serviceaccounts. Index exceeds size.");
    return setNewServiceaccountLike(index, buildServiceaccount(index));
  }
  public io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent.ServiceaccountsNested<A> editFirstServiceaccount() {
    if (serviceaccounts.size() == 0) throw new RuntimeException("Can't edit first serviceaccounts. The list is empty.");
    return setNewServiceaccountLike(0, buildServiceaccount(0));
  }
  public io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent.ServiceaccountsNested<A> editLastServiceaccount() {
    int index = serviceaccounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last serviceaccounts. The list is empty.");
    return setNewServiceaccountLike(index, buildServiceaccount(index));
  }
  public io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent.ServiceaccountsNested<A> editMatchingServiceaccount(java.util.function.Predicate<io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<serviceaccounts.size();i++) { 
    if (predicate.test(serviceaccounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching serviceaccounts. No match found.");
    return setNewServiceaccountLike(index, buildServiceaccount(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceAccountRestrictionFluentImpl that = (ServiceAccountRestrictionFluentImpl) o;
    if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
    if (serviceaccounts != null ? !serviceaccounts.equals(that.serviceaccounts) :that.serviceaccounts != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(namespaces,  serviceaccounts,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (namespaces != null && !namespaces.isEmpty()) { sb.append("namespaces:"); sb.append(namespaces + ","); }
    if (serviceaccounts != null && !serviceaccounts.isEmpty()) { sb.append("serviceaccounts:"); sb.append(serviceaccounts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ServiceaccountsNestedImpl<N> extends ServiceAccountReferenceFluentImpl<ServiceAccountRestrictionFluent.ServiceaccountsNested<N>> implements io.fabric8.openshift.api.model.ServiceAccountRestrictionFluent.ServiceaccountsNested<N>,Nested<N>{
    ServiceaccountsNestedImpl(java.lang.Integer index,ServiceAccountReference item) {
      this.index = index;
      this.builder = new ServiceAccountReferenceBuilder(this, item);
    }
    ServiceaccountsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.ServiceAccountReferenceBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ServiceAccountRestrictionFluentImpl.this.setToServiceaccounts(index,builder.build());
    }
    public N endServiceaccount() {
      return and();
    }
    
  }
  
}