package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceAccountReferenceBuilder extends ServiceAccountReferenceFluentImpl<ServiceAccountReferenceBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ServiceAccountReference,ServiceAccountReferenceBuilder>{
  public ServiceAccountReferenceBuilder() {
    this(false);
  }
  public ServiceAccountReferenceBuilder(Boolean validationEnabled) {
    this(new ServiceAccountReference(), validationEnabled);
  }
  public ServiceAccountReferenceBuilder(ServiceAccountReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceAccountReference(), validationEnabled);
  }
  public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ServiceAccountReference instance) {
    this(fluent, instance, false);
  }
  public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReferenceFluent<?> fluent,io.fabric8.openshift.api.model.ServiceAccountReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReference instance) {
    this(instance,false);
  }
  public ServiceAccountReferenceBuilder(io.fabric8.openshift.api.model.ServiceAccountReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ServiceAccountReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ServiceAccountReference build() {
    ServiceAccountReference buildable = new ServiceAccountReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}