package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecurityContextConstraintsListBuilder extends SecurityContextConstraintsListFluentImpl<SecurityContextConstraintsListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.SecurityContextConstraintsList,io.fabric8.openshift.api.model.SecurityContextConstraintsListBuilder>{
  public SecurityContextConstraintsListBuilder() {
    this(false);
  }
  public SecurityContextConstraintsListBuilder(Boolean validationEnabled) {
    this(new SecurityContextConstraintsList(), validationEnabled);
  }
  public SecurityContextConstraintsListBuilder(SecurityContextConstraintsListFluent<?> fluent) {
    this(fluent, false);
  }
  public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecurityContextConstraintsList(), validationEnabled);
  }
  public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsListFluent<?> fluent,io.fabric8.openshift.api.model.SecurityContextConstraintsList instance) {
    this(fluent, instance, false);
  }
  public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsListFluent<?> fluent,io.fabric8.openshift.api.model.SecurityContextConstraintsList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsList instance) {
    this(instance,false);
  }
  public SecurityContextConstraintsListBuilder(io.fabric8.openshift.api.model.SecurityContextConstraintsList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SecurityContextConstraintsListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SecurityContextConstraintsList build() {
    SecurityContextConstraintsList buildable = new SecurityContextConstraintsList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}