package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretSpecBuilder extends SecretSpecFluentImpl<SecretSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.SecretSpec,io.fabric8.openshift.api.model.SecretSpecBuilder>{
  public SecretSpecBuilder() {
    this(false);
  }
  public SecretSpecBuilder(Boolean validationEnabled) {
    this(new SecretSpec(), validationEnabled);
  }
  public SecretSpecBuilder(SecretSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretSpec(), validationEnabled);
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpecFluent<?> fluent,io.fabric8.openshift.api.model.SecretSpec instance) {
    this(fluent, instance, false);
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpecFluent<?> fluent,io.fabric8.openshift.api.model.SecretSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMountPath(instance.getMountPath()); 
    fluent.withSecretSource(instance.getSecretSource()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpec instance) {
    this(instance,false);
  }
  public SecretSpecBuilder(io.fabric8.openshift.api.model.SecretSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMountPath(instance.getMountPath()); 
    this.withSecretSource(instance.getSecretSource()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SecretSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SecretSpec build() {
    SecretSpec buildable = new SecretSpec(fluent.getMountPath(),fluent.getSecretSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}