package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretNameReferenceBuilder extends SecretNameReferenceFluentImpl<SecretNameReferenceBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.SecretNameReference,SecretNameReferenceBuilder>{
  public SecretNameReferenceBuilder() {
    this(false);
  }
  public SecretNameReferenceBuilder(Boolean validationEnabled) {
    this(new SecretNameReference(), validationEnabled);
  }
  public SecretNameReferenceBuilder(SecretNameReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretNameReference(), validationEnabled);
  }
  public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReferenceFluent<?> fluent,io.fabric8.openshift.api.model.SecretNameReference instance) {
    this(fluent, instance, false);
  }
  public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReferenceFluent<?> fluent,io.fabric8.openshift.api.model.SecretNameReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReference instance) {
    this(instance,false);
  }
  public SecretNameReferenceBuilder(io.fabric8.openshift.api.model.SecretNameReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SecretNameReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SecretNameReference build() {
    SecretNameReference buildable = new SecretNameReference(fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}