package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretBuildSourceBuilder extends SecretBuildSourceFluentImpl<SecretBuildSourceBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.SecretBuildSource,io.fabric8.openshift.api.model.SecretBuildSourceBuilder>{
  public SecretBuildSourceBuilder() {
    this(false);
  }
  public SecretBuildSourceBuilder(Boolean validationEnabled) {
    this(new SecretBuildSource(), validationEnabled);
  }
  public SecretBuildSourceBuilder(SecretBuildSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretBuildSourceBuilder(io.fabric8.openshift.api.model.SecretBuildSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SecretBuildSource(), validationEnabled);
  }
  public SecretBuildSourceBuilder(io.fabric8.openshift.api.model.SecretBuildSourceFluent<?> fluent,io.fabric8.openshift.api.model.SecretBuildSource instance) {
    this(fluent, instance, false);
  }
  public SecretBuildSourceBuilder(io.fabric8.openshift.api.model.SecretBuildSourceFluent<?> fluent,io.fabric8.openshift.api.model.SecretBuildSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDestinationDir(instance.getDestinationDir()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SecretBuildSourceBuilder(io.fabric8.openshift.api.model.SecretBuildSource instance) {
    this(instance,false);
  }
  public SecretBuildSourceBuilder(io.fabric8.openshift.api.model.SecretBuildSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDestinationDir(instance.getDestinationDir()); 
    this.withSecret(instance.getSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SecretBuildSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SecretBuildSource build() {
    SecretBuildSource buildable = new SecretBuildSource(fluent.getDestinationDir(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}