package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScopeRestrictionBuilder extends ScopeRestrictionFluentImpl<ScopeRestrictionBuilder> implements VisitableBuilder<ScopeRestriction,io.fabric8.openshift.api.model.ScopeRestrictionBuilder>{
  public ScopeRestrictionBuilder() {
    this(false);
  }
  public ScopeRestrictionBuilder(Boolean validationEnabled) {
    this(new ScopeRestriction(), validationEnabled);
  }
  public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent) {
    this(fluent, false);
  }
  public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ScopeRestriction(), validationEnabled);
  }
  public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.ScopeRestriction instance) {
    this(fluent, instance, false);
  }
  public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.ScopeRestriction instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterRole(instance.getClusterRole()); 
    fluent.withLiterals(instance.getLiterals()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestriction instance) {
    this(instance,false);
  }
  public ScopeRestrictionBuilder(io.fabric8.openshift.api.model.ScopeRestriction instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterRole(instance.getClusterRole()); 
    this.withLiterals(instance.getLiterals()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ScopeRestrictionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ScopeRestriction build() {
    ScopeRestriction buildable = new ScopeRestriction(fluent.getClusterRole(),fluent.getLiterals());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}