package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SchedulerSpecBuilder extends SchedulerSpecFluentImpl<SchedulerSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.SchedulerSpec,io.fabric8.openshift.api.model.SchedulerSpecBuilder>{
  public SchedulerSpecBuilder() {
    this(false);
  }
  public SchedulerSpecBuilder(Boolean validationEnabled) {
    this(new SchedulerSpec(), validationEnabled);
  }
  public SchedulerSpecBuilder(SchedulerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SchedulerSpecBuilder(io.fabric8.openshift.api.model.SchedulerSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SchedulerSpec(), validationEnabled);
  }
  public SchedulerSpecBuilder(io.fabric8.openshift.api.model.SchedulerSpecFluent<?> fluent,io.fabric8.openshift.api.model.SchedulerSpec instance) {
    this(fluent, instance, false);
  }
  public SchedulerSpecBuilder(io.fabric8.openshift.api.model.SchedulerSpecFluent<?> fluent,io.fabric8.openshift.api.model.SchedulerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDefaultNodeSelector(instance.getDefaultNodeSelector()); 
    fluent.withMastersSchedulable(instance.getMastersSchedulable()); 
    fluent.withPolicy(instance.getPolicy()); 
    fluent.withProfile(instance.getProfile()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SchedulerSpecBuilder(io.fabric8.openshift.api.model.SchedulerSpec instance) {
    this(instance,false);
  }
  public SchedulerSpecBuilder(io.fabric8.openshift.api.model.SchedulerSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDefaultNodeSelector(instance.getDefaultNodeSelector()); 
    this.withMastersSchedulable(instance.getMastersSchedulable()); 
    this.withPolicy(instance.getPolicy()); 
    this.withProfile(instance.getProfile()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SchedulerSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SchedulerSpec build() {
    SchedulerSpec buildable = new SchedulerSpec(fluent.getDefaultNodeSelector(),fluent.getMastersSchedulable(),fluent.getPolicy(),fluent.getProfile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}