package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SchedulerListBuilder extends SchedulerListFluentImpl<SchedulerListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.SchedulerList,io.fabric8.openshift.api.model.SchedulerListBuilder>{
  public SchedulerListBuilder() {
    this(false);
  }
  public SchedulerListBuilder(Boolean validationEnabled) {
    this(new SchedulerList(), validationEnabled);
  }
  public SchedulerListBuilder(SchedulerListFluent<?> fluent) {
    this(fluent, false);
  }
  public SchedulerListBuilder(io.fabric8.openshift.api.model.SchedulerListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new SchedulerList(), validationEnabled);
  }
  public SchedulerListBuilder(io.fabric8.openshift.api.model.SchedulerListFluent<?> fluent,io.fabric8.openshift.api.model.SchedulerList instance) {
    this(fluent, instance, false);
  }
  public SchedulerListBuilder(io.fabric8.openshift.api.model.SchedulerListFluent<?> fluent,io.fabric8.openshift.api.model.SchedulerList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SchedulerListBuilder(io.fabric8.openshift.api.model.SchedulerList instance) {
    this(instance,false);
  }
  public SchedulerListBuilder(io.fabric8.openshift.api.model.SchedulerList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SchedulerListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.SchedulerList build() {
    SchedulerList buildable = new SchedulerList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}