package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SchedulerBuilder extends SchedulerFluentImpl<SchedulerBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.Scheduler,SchedulerBuilder>{
  public SchedulerBuilder() {
    this(false);
  }
  public SchedulerBuilder(Boolean validationEnabled) {
    this(new Scheduler(), validationEnabled);
  }
  public SchedulerBuilder(io.fabric8.openshift.api.model.SchedulerFluent<?> fluent) {
    this(fluent, false);
  }
  public SchedulerBuilder(io.fabric8.openshift.api.model.SchedulerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Scheduler(), validationEnabled);
  }
  public SchedulerBuilder(io.fabric8.openshift.api.model.SchedulerFluent<?> fluent,io.fabric8.openshift.api.model.Scheduler instance) {
    this(fluent, instance, false);
  }
  public SchedulerBuilder(io.fabric8.openshift.api.model.SchedulerFluent<?> fluent,io.fabric8.openshift.api.model.Scheduler instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SchedulerBuilder(io.fabric8.openshift.api.model.Scheduler instance) {
    this(instance,false);
  }
  public SchedulerBuilder(io.fabric8.openshift.api.model.Scheduler instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.SchedulerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Scheduler build() {
    Scheduler buildable = new Scheduler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}