package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteTargetReferenceBuilder extends RouteTargetReferenceFluentImpl<RouteTargetReferenceBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.RouteTargetReference,io.fabric8.openshift.api.model.RouteTargetReferenceBuilder>{
  public RouteTargetReferenceBuilder() {
    this(false);
  }
  public RouteTargetReferenceBuilder(Boolean validationEnabled) {
    this(new RouteTargetReference(), validationEnabled);
  }
  public RouteTargetReferenceBuilder(RouteTargetReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RouteTargetReference(), validationEnabled);
  }
  public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReferenceFluent<?> fluent,io.fabric8.openshift.api.model.RouteTargetReference instance) {
    this(fluent, instance, false);
  }
  public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReferenceFluent<?> fluent,io.fabric8.openshift.api.model.RouteTargetReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withWeight(instance.getWeight()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReference instance) {
    this(instance,false);
  }
  public RouteTargetReferenceBuilder(io.fabric8.openshift.api.model.RouteTargetReference instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withWeight(instance.getWeight()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.RouteTargetReferenceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.RouteTargetReference build() {
    RouteTargetReference buildable = new RouteTargetReference(fluent.getKind(),fluent.getName(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}