package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteStatusBuilder extends RouteStatusFluentImpl<RouteStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.RouteStatus,RouteStatusBuilder>{
  public RouteStatusBuilder() {
    this(false);
  }
  public RouteStatusBuilder(Boolean validationEnabled) {
    this(new RouteStatus(), validationEnabled);
  }
  public RouteStatusBuilder(io.fabric8.openshift.api.model.RouteStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteStatusBuilder(io.fabric8.openshift.api.model.RouteStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RouteStatus(), validationEnabled);
  }
  public RouteStatusBuilder(io.fabric8.openshift.api.model.RouteStatusFluent<?> fluent,io.fabric8.openshift.api.model.RouteStatus instance) {
    this(fluent, instance, false);
  }
  public RouteStatusBuilder(io.fabric8.openshift.api.model.RouteStatusFluent<?> fluent,io.fabric8.openshift.api.model.RouteStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIngress(instance.getIngress()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteStatusBuilder(io.fabric8.openshift.api.model.RouteStatus instance) {
    this(instance,false);
  }
  public RouteStatusBuilder(io.fabric8.openshift.api.model.RouteStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withIngress(instance.getIngress()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.RouteStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.RouteStatus build() {
    RouteStatus buildable = new RouteStatus(fluent.getIngress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}