package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteSpecBuilder extends RouteSpecFluentImpl<RouteSpecBuilder> implements VisitableBuilder<RouteSpec,io.fabric8.openshift.api.model.RouteSpecBuilder>{
  public RouteSpecBuilder() {
    this(false);
  }
  public RouteSpecBuilder(Boolean validationEnabled) {
    this(new RouteSpec(), validationEnabled);
  }
  public RouteSpecBuilder(RouteSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteSpecBuilder(io.fabric8.openshift.api.model.RouteSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RouteSpec(), validationEnabled);
  }
  public RouteSpecBuilder(io.fabric8.openshift.api.model.RouteSpecFluent<?> fluent,io.fabric8.openshift.api.model.RouteSpec instance) {
    this(fluent, instance, false);
  }
  public RouteSpecBuilder(io.fabric8.openshift.api.model.RouteSpecFluent<?> fluent,io.fabric8.openshift.api.model.RouteSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAlternateBackends(instance.getAlternateBackends()); 
    fluent.withHost(instance.getHost()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    fluent.withSubdomain(instance.getSubdomain()); 
    fluent.withTls(instance.getTls()); 
    fluent.withTo(instance.getTo()); 
    fluent.withWildcardPolicy(instance.getWildcardPolicy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteSpecBuilder(io.fabric8.openshift.api.model.RouteSpec instance) {
    this(instance,false);
  }
  public RouteSpecBuilder(io.fabric8.openshift.api.model.RouteSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAlternateBackends(instance.getAlternateBackends()); 
    this.withHost(instance.getHost()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withSubdomain(instance.getSubdomain()); 
    this.withTls(instance.getTls()); 
    this.withTo(instance.getTo()); 
    this.withWildcardPolicy(instance.getWildcardPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.RouteSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.RouteSpec build() {
    RouteSpec buildable = new RouteSpec(fluent.getAlternateBackends(),fluent.getHost(),fluent.getPath(),fluent.getPort(),fluent.getSubdomain(),fluent.getTls(),fluent.getTo(),fluent.getWildcardPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}