package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteListBuilder extends RouteListFluentImpl<RouteListBuilder> implements VisitableBuilder<RouteList,io.fabric8.openshift.api.model.RouteListBuilder>{
  public RouteListBuilder() {
    this(false);
  }
  public RouteListBuilder(Boolean validationEnabled) {
    this(new RouteList(), validationEnabled);
  }
  public RouteListBuilder(io.fabric8.openshift.api.model.RouteListFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteListBuilder(io.fabric8.openshift.api.model.RouteListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RouteList(), validationEnabled);
  }
  public RouteListBuilder(io.fabric8.openshift.api.model.RouteListFluent<?> fluent,io.fabric8.openshift.api.model.RouteList instance) {
    this(fluent, instance, false);
  }
  public RouteListBuilder(io.fabric8.openshift.api.model.RouteListFluent<?> fluent,io.fabric8.openshift.api.model.RouteList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RouteListBuilder(io.fabric8.openshift.api.model.RouteList instance) {
    this(instance,false);
  }
  public RouteListBuilder(io.fabric8.openshift.api.model.RouteList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.RouteListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.RouteList build() {
    RouteList buildable = new RouteList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}