package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RequiredHSTSPolicyFluentImpl<A extends RequiredHSTSPolicyFluent<A>> extends BaseFluent<A> implements RequiredHSTSPolicyFluent<A>{
  public RequiredHSTSPolicyFluentImpl() {
  }
  public RequiredHSTSPolicyFluentImpl(io.fabric8.openshift.api.model.RequiredHSTSPolicy instance) {
    this.withDomainPatterns(instance.getDomainPatterns()); 
    this.withIncludeSubDomainsPolicy(instance.getIncludeSubDomainsPolicy()); 
    this.withMaxAge(instance.getMaxAge()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withPreloadPolicy(instance.getPreloadPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<String> domainPatterns = new ArrayList<java.lang.String>();
  private java.lang.String includeSubDomainsPolicy;
  private MaxAgePolicyBuilder maxAge;
  private LabelSelectorBuilder namespaceSelector;
  private java.lang.String preloadPolicy;
  private Map<java.lang.String,Object> additionalProperties;
  public A addToDomainPatterns(Integer index,java.lang.String item) {
    if (this.domainPatterns == null) {this.domainPatterns = new java.util.ArrayList<java.lang.String>();}
    this.domainPatterns.add(index, item);
    return (A)this;
  }
  public A setToDomainPatterns(java.lang.Integer index,java.lang.String item) {
    if (this.domainPatterns == null) {this.domainPatterns = new java.util.ArrayList<java.lang.String>();}
    this.domainPatterns.set(index, item); return (A)this;
  }
  public A addToDomainPatterns(java.lang.String... items) {
    if (this.domainPatterns == null) {this.domainPatterns = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.domainPatterns.add(item);} return (A)this;
  }
  public A addAllToDomainPatterns(Collection<java.lang.String> items) {
    if (this.domainPatterns == null) {this.domainPatterns = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.domainPatterns.add(item);} return (A)this;
  }
  public A removeFromDomainPatterns(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.domainPatterns!= null){ this.domainPatterns.remove(item);}} return (A)this;
  }
  public A removeAllFromDomainPatterns(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.domainPatterns!= null){ this.domainPatterns.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getDomainPatterns() {
    return this.domainPatterns;
  }
  public java.lang.String getDomainPattern(java.lang.Integer index) {
    return this.domainPatterns.get(index);
  }
  public java.lang.String getFirstDomainPattern() {
    return this.domainPatterns.get(0);
  }
  public java.lang.String getLastDomainPattern() {
    return this.domainPatterns.get(domainPatterns.size() - 1);
  }
  public java.lang.String getMatchingDomainPattern(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: domainPatterns) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDomainPattern(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: domainPatterns) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDomainPatterns(java.util.List<java.lang.String> domainPatterns) {
    if (domainPatterns != null) {this.domainPatterns = new java.util.ArrayList(); for (java.lang.String item : domainPatterns){this.addToDomainPatterns(item);}} else { this.domainPatterns = null;} return (A) this;
  }
  public A withDomainPatterns(java.lang.String... domainPatterns) {
    if (this.domainPatterns != null) {this.domainPatterns.clear();}
    if (domainPatterns != null) {for (java.lang.String item :domainPatterns){ this.addToDomainPatterns(item);}} return (A) this;
  }
  public java.lang.Boolean hasDomainPatterns() {
    return domainPatterns != null && !domainPatterns.isEmpty();
  }
  public java.lang.String getIncludeSubDomainsPolicy() {
    return this.includeSubDomainsPolicy;
  }
  public A withIncludeSubDomainsPolicy(java.lang.String includeSubDomainsPolicy) {
    this.includeSubDomainsPolicy=includeSubDomainsPolicy; return (A) this;
  }
  public java.lang.Boolean hasIncludeSubDomainsPolicy() {
    return this.includeSubDomainsPolicy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMaxAge instead.
   * @return The buildable object.
   */
  @Deprecated
  public MaxAgePolicy getMaxAge() {
    return this.maxAge!=null ?this.maxAge.build():null;
  }
  public io.fabric8.openshift.api.model.MaxAgePolicy buildMaxAge() {
    return this.maxAge!=null ?this.maxAge.build():null;
  }
  public A withMaxAge(io.fabric8.openshift.api.model.MaxAgePolicy maxAge) {
    _visitables.get("maxAge").remove(this.maxAge);
    if (maxAge!=null){ this.maxAge= new io.fabric8.openshift.api.model.MaxAgePolicyBuilder(maxAge); _visitables.get("maxAge").add(this.maxAge);} return (A) this;
  }
  public java.lang.Boolean hasMaxAge() {
    return this.maxAge != null;
  }
  public A withNewMaxAge(java.lang.Integer largestMaxAge,java.lang.Integer smallestMaxAge) {
    return (A)withMaxAge(new MaxAgePolicy(largestMaxAge, smallestMaxAge));
  }
  public RequiredHSTSPolicyFluent.MaxAgeNested<A> withNewMaxAge() {
    return new RequiredHSTSPolicyFluentImpl.MaxAgeNestedImpl();
  }
  public io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.MaxAgeNested<A> withNewMaxAgeLike(io.fabric8.openshift.api.model.MaxAgePolicy item) {
    return new RequiredHSTSPolicyFluentImpl.MaxAgeNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.MaxAgeNested<A> editMaxAge() {
    return withNewMaxAgeLike(getMaxAge());
  }
  public io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.MaxAgeNested<A> editOrNewMaxAge() {
    return withNewMaxAgeLike(getMaxAge() != null ? getMaxAge(): new io.fabric8.openshift.api.model.MaxAgePolicyBuilder().build());
  }
  public io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.MaxAgeNested<A> editOrNewMaxAgeLike(io.fabric8.openshift.api.model.MaxAgePolicy item) {
    return withNewMaxAgeLike(getMaxAge() != null ? getMaxAge(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LabelSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(io.fabric8.kubernetes.api.model.LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} return (A) this;
  }
  public java.lang.Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new RequiredHSTSPolicyFluentImpl.NamespaceSelectorNestedImpl();
  }
  public io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.openshift.api.model.RequiredHSTSPolicyFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  public java.lang.String getPreloadPolicy() {
    return this.preloadPolicy;
  }
  public A withPreloadPolicy(java.lang.String preloadPolicy) {
    this.preloadPolicy=preloadPolicy; return (A) this;
  }
  public java.lang.Boolean hasPreloadPolicy() {
    return this.preloadPolicy != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RequiredHSTSPolicyFluentImpl that = (RequiredHSTSPolicyFluentImpl) o;
    if (domainPatterns != null ? !domainPatterns.equals(that.domainPatterns) :that.domainPatterns != null) return false;
    if (includeSubDomainsPolicy != null ? !includeSubDomainsPolicy.equals(that.includeSubDomainsPolicy) :that.includeSubDomainsPolicy != null) return false;
    if (maxAge != null ? !maxAge.equals(that.maxAge) :that.maxAge != null) return false;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (preloadPolicy != null ? !preloadPolicy.equals(that.preloadPolicy) :that.preloadPolicy != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(domainPatterns,  includeSubDomainsPolicy,  maxAge,  namespaceSelector,  preloadPolicy,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (domainPatterns != null && !domainPatterns.isEmpty()) { sb.append("domainPatterns:"); sb.append(domainPatterns + ","); }
    if (includeSubDomainsPolicy != null) { sb.append("includeSubDomainsPolicy:"); sb.append(includeSubDomainsPolicy + ","); }
    if (maxAge != null) { sb.append("maxAge:"); sb.append(maxAge + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (preloadPolicy != null) { sb.append("preloadPolicy:"); sb.append(preloadPolicy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MaxAgeNestedImpl<N> extends MaxAgePolicyFluentImpl<RequiredHSTSPolicyFluent.MaxAgeNested<N>> implements io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.MaxAgeNested<N>,Nested<N>{
    MaxAgeNestedImpl(io.fabric8.openshift.api.model.MaxAgePolicy item) {
      this.builder = new MaxAgePolicyBuilder(this, item);
    }
    MaxAgeNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.MaxAgePolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.MaxAgePolicyBuilder builder;
    public N and() {
      return (N) RequiredHSTSPolicyFluentImpl.this.withMaxAge(builder.build());
    }
    public N endMaxAge() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<RequiredHSTSPolicyFluent.NamespaceSelectorNested<N>> implements io.fabric8.openshift.api.model.RequiredHSTSPolicyFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    NamespaceSelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) RequiredHSTSPolicyFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  
}