package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxySpecBuilder extends ProxySpecFluentImpl<ProxySpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ProxySpec,ProxySpecBuilder>{
  public ProxySpecBuilder() {
    this(false);
  }
  public ProxySpecBuilder(Boolean validationEnabled) {
    this(new ProxySpec(), validationEnabled);
  }
  public ProxySpecBuilder(ProxySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProxySpec(), validationEnabled);
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpecFluent<?> fluent,io.fabric8.openshift.api.model.ProxySpec instance) {
    this(fluent, instance, false);
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpecFluent<?> fluent,io.fabric8.openshift.api.model.ProxySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHttpProxy(instance.getHttpProxy()); 
    fluent.withHttpsProxy(instance.getHttpsProxy()); 
    fluent.withNoProxy(instance.getNoProxy()); 
    fluent.withReadinessEndpoints(instance.getReadinessEndpoints()); 
    fluent.withTrustedCA(instance.getTrustedCA()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpec instance) {
    this(instance,false);
  }
  public ProxySpecBuilder(io.fabric8.openshift.api.model.ProxySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHttpProxy(instance.getHttpProxy()); 
    this.withHttpsProxy(instance.getHttpsProxy()); 
    this.withNoProxy(instance.getNoProxy()); 
    this.withReadinessEndpoints(instance.getReadinessEndpoints()); 
    this.withTrustedCA(instance.getTrustedCA()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ProxySpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ProxySpec build() {
    ProxySpec buildable = new ProxySpec(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getReadinessEndpoints(),fluent.getTrustedCA());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}