package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxyListBuilder extends ProxyListFluentImpl<ProxyListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ProxyList,io.fabric8.openshift.api.model.ProxyListBuilder>{
  public ProxyListBuilder() {
    this(false);
  }
  public ProxyListBuilder(Boolean validationEnabled) {
    this(new ProxyList(), validationEnabled);
  }
  public ProxyListBuilder(ProxyListFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyListBuilder(io.fabric8.openshift.api.model.ProxyListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ProxyList(), validationEnabled);
  }
  public ProxyListBuilder(io.fabric8.openshift.api.model.ProxyListFluent<?> fluent,io.fabric8.openshift.api.model.ProxyList instance) {
    this(fluent, instance, false);
  }
  public ProxyListBuilder(io.fabric8.openshift.api.model.ProxyListFluent<?> fluent,io.fabric8.openshift.api.model.ProxyList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProxyListBuilder(io.fabric8.openshift.api.model.ProxyList instance) {
    this(instance,false);
  }
  public ProxyListBuilder(io.fabric8.openshift.api.model.ProxyList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ProxyListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ProxyList build() {
    ProxyList buildable = new ProxyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}