package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProxyBuilder extends ProxyFluentImpl<ProxyBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.Proxy,io.fabric8.openshift.api.model.ProxyBuilder>{
  public ProxyBuilder() {
    this(false);
  }
  public ProxyBuilder(Boolean validationEnabled) {
    this(new Proxy(), validationEnabled);
  }
  public ProxyBuilder(ProxyFluent<?> fluent) {
    this(fluent, false);
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.ProxyFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Proxy(), validationEnabled);
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.ProxyFluent<?> fluent,io.fabric8.openshift.api.model.Proxy instance) {
    this(fluent, instance, false);
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.ProxyFluent<?> fluent,io.fabric8.openshift.api.model.Proxy instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.Proxy instance) {
    this(instance,false);
  }
  public ProxyBuilder(io.fabric8.openshift.api.model.Proxy instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ProxyFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Proxy build() {
    Proxy buildable = new Proxy(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}