package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PowerVSServiceEndpointBuilder extends PowerVSServiceEndpointFluentImpl<PowerVSServiceEndpointBuilder> implements VisitableBuilder<PowerVSServiceEndpoint,io.fabric8.openshift.api.model.PowerVSServiceEndpointBuilder>{
  public PowerVSServiceEndpointBuilder() {
    this(false);
  }
  public PowerVSServiceEndpointBuilder(Boolean validationEnabled) {
    this(new PowerVSServiceEndpoint(), validationEnabled);
  }
  public PowerVSServiceEndpointBuilder(PowerVSServiceEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpointFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PowerVSServiceEndpoint(), validationEnabled);
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpointFluent<?> fluent,io.fabric8.openshift.api.model.PowerVSServiceEndpoint instance) {
    this(fluent, instance, false);
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpointFluent<?> fluent,io.fabric8.openshift.api.model.PowerVSServiceEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpoint instance) {
    this(instance,false);
  }
  public PowerVSServiceEndpointBuilder(io.fabric8.openshift.api.model.PowerVSServiceEndpoint instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.PowerVSServiceEndpointFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.PowerVSServiceEndpoint build() {
    PowerVSServiceEndpoint buildable = new PowerVSServiceEndpoint(fluent.getName(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}