package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodSecurityPolicyReviewSpecBuilder extends PodSecurityPolicyReviewSpecFluentImpl<PodSecurityPolicyReviewSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpec,PodSecurityPolicyReviewSpecBuilder>{
  public PodSecurityPolicyReviewSpecBuilder() {
    this(false);
  }
  public PodSecurityPolicyReviewSpecBuilder(Boolean validationEnabled) {
    this(new PodSecurityPolicyReviewSpec(), validationEnabled);
  }
  public PodSecurityPolicyReviewSpecBuilder(io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PodSecurityPolicyReviewSpecBuilder(io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PodSecurityPolicyReviewSpec(), validationEnabled);
  }
  public PodSecurityPolicyReviewSpecBuilder(io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent<?> fluent,io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpec instance) {
    this(fluent, instance, false);
  }
  public PodSecurityPolicyReviewSpecBuilder(io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent<?> fluent,io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withServiceAccountNames(instance.getServiceAccountNames()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PodSecurityPolicyReviewSpecBuilder(io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpec instance) {
    this(instance,false);
  }
  public PodSecurityPolicyReviewSpecBuilder(io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withServiceAccountNames(instance.getServiceAccountNames()); 
    this.withTemplate(instance.getTemplate()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.PodSecurityPolicyReviewSpec build() {
    PodSecurityPolicyReviewSpec buildable = new PodSecurityPolicyReviewSpec(fluent.getServiceAccountNames(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}