package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OperatorHubFluentImpl<A extends OperatorHubFluent<A>> extends BaseFluent<A> implements OperatorHubFluent<A>{
  public OperatorHubFluentImpl() {
  }
  public OperatorHubFluentImpl(io.fabric8.openshift.api.model.OperatorHub instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private OperatorHubSpecBuilder spec;
  private OperatorHubStatusBuilder status;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public OperatorHubFluent.MetadataNested<A> withNewMetadata() {
    return new OperatorHubFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new OperatorHubFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.OperatorHubSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public io.fabric8.openshift.api.model.OperatorHubSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(io.fabric8.openshift.api.model.OperatorHubSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new OperatorHubSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
  }
  public java.lang.Boolean hasSpec() {
    return this.spec != null;
  }
  public OperatorHubFluent.SpecNested<A> withNewSpec() {
    return new OperatorHubFluentImpl.SpecNestedImpl();
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.SpecNested<A> withNewSpecLike(io.fabric8.openshift.api.model.OperatorHubSpec item) {
    return new io.fabric8.openshift.api.model.OperatorHubFluentImpl.SpecNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new io.fabric8.openshift.api.model.OperatorHubSpecBuilder().build());
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.SpecNested<A> editOrNewSpecLike(io.fabric8.openshift.api.model.OperatorHubSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.OperatorHubStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public io.fabric8.openshift.api.model.OperatorHubStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(io.fabric8.openshift.api.model.OperatorHubStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new OperatorHubStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
  }
  public java.lang.Boolean hasStatus() {
    return this.status != null;
  }
  public OperatorHubFluent.StatusNested<A> withNewStatus() {
    return new OperatorHubFluentImpl.StatusNestedImpl();
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.StatusNested<A> withNewStatusLike(io.fabric8.openshift.api.model.OperatorHubStatus item) {
    return new io.fabric8.openshift.api.model.OperatorHubFluentImpl.StatusNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new io.fabric8.openshift.api.model.OperatorHubStatusBuilder().build());
  }
  public io.fabric8.openshift.api.model.OperatorHubFluent.StatusNested<A> editOrNewStatusLike(io.fabric8.openshift.api.model.OperatorHubStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OperatorHubFluentImpl that = (OperatorHubFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<OperatorHubFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.OperatorHubFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) OperatorHubFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends OperatorHubSpecFluentImpl<OperatorHubFluent.SpecNested<N>> implements io.fabric8.openshift.api.model.OperatorHubFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SpecNestedImpl(io.fabric8.openshift.api.model.OperatorHubSpec item) {
      this.builder = new OperatorHubSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OperatorHubSpecBuilder(this);
    }
    io.fabric8.openshift.api.model.OperatorHubSpecBuilder builder;
    public N and() {
      return (N) OperatorHubFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends OperatorHubStatusFluentImpl<OperatorHubFluent.StatusNested<N>> implements io.fabric8.openshift.api.model.OperatorHubFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StatusNestedImpl(io.fabric8.openshift.api.model.OperatorHubStatus item) {
      this.builder = new OperatorHubStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.OperatorHubStatusBuilder(this);
    }
    io.fabric8.openshift.api.model.OperatorHubStatusBuilder builder;
    public N and() {
      return (N) OperatorHubFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}