package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OpenIDIdentityProviderBuilder extends OpenIDIdentityProviderFluentImpl<OpenIDIdentityProviderBuilder> implements VisitableBuilder<OpenIDIdentityProvider,io.fabric8.openshift.api.model.OpenIDIdentityProviderBuilder>{
  public OpenIDIdentityProviderBuilder() {
    this(false);
  }
  public OpenIDIdentityProviderBuilder(Boolean validationEnabled) {
    this(new OpenIDIdentityProvider(), validationEnabled);
  }
  public OpenIDIdentityProviderBuilder(io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public OpenIDIdentityProviderBuilder(io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OpenIDIdentityProvider(), validationEnabled);
  }
  public OpenIDIdentityProviderBuilder(io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.OpenIDIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public OpenIDIdentityProviderBuilder(io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.OpenIDIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCa(instance.getCa()); 
    fluent.withClaims(instance.getClaims()); 
    fluent.withClientID(instance.getClientID()); 
    fluent.withClientSecret(instance.getClientSecret()); 
    fluent.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters()); 
    fluent.withExtraScopes(instance.getExtraScopes()); 
    fluent.withIssuer(instance.getIssuer()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OpenIDIdentityProviderBuilder(io.fabric8.openshift.api.model.OpenIDIdentityProvider instance) {
    this(instance,false);
  }
  public OpenIDIdentityProviderBuilder(io.fabric8.openshift.api.model.OpenIDIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCa(instance.getCa()); 
    this.withClaims(instance.getClaims()); 
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters()); 
    this.withExtraScopes(instance.getExtraScopes()); 
    this.withIssuer(instance.getIssuer()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OpenIDIdentityProviderFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OpenIDIdentityProvider build() {
    OpenIDIdentityProvider buildable = new OpenIDIdentityProvider(fluent.getCa(),fluent.getClaims(),fluent.getClientID(),fluent.getClientSecret(),fluent.getExtraAuthorizeParameters(),fluent.getExtraScopes(),fluent.getIssuer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}