package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthClientListBuilder extends OAuthClientListFluentImpl<OAuthClientListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.OAuthClientList,io.fabric8.openshift.api.model.OAuthClientListBuilder>{
  public OAuthClientListBuilder() {
    this(false);
  }
  public OAuthClientListBuilder(Boolean validationEnabled) {
    this(new OAuthClientList(), validationEnabled);
  }
  public OAuthClientListBuilder(OAuthClientListFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuthClientList(), validationEnabled);
  }
  public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientListFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClientList instance) {
    this(fluent, instance, false);
  }
  public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientListFluent<?> fluent,io.fabric8.openshift.api.model.OAuthClientList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientList instance) {
    this(instance,false);
  }
  public OAuthClientListBuilder(io.fabric8.openshift.api.model.OAuthClientList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthClientListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuthClientList build() {
    OAuthClientList buildable = new OAuthClientList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}