package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthBuilder extends OAuthFluentImpl<OAuthBuilder> implements VisitableBuilder<OAuth,io.fabric8.openshift.api.model.OAuthBuilder>{
  public OAuthBuilder() {
    this(false);
  }
  public OAuthBuilder(Boolean validationEnabled) {
    this(new OAuth(), validationEnabled);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuthFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuth(), validationEnabled);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuthFluent<?> fluent,io.fabric8.openshift.api.model.OAuth instance) {
    this(fluent, instance, false);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuthFluent<?> fluent,io.fabric8.openshift.api.model.OAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuth instance) {
    this(instance,false);
  }
  public OAuthBuilder(io.fabric8.openshift.api.model.OAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuth build() {
    OAuth buildable = new OAuth(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}