package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthAuthorizeTokenBuilder extends OAuthAuthorizeTokenFluentImpl<OAuthAuthorizeTokenBuilder> implements VisitableBuilder<OAuthAuthorizeToken,io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder>{
  public OAuthAuthorizeTokenBuilder() {
    this(false);
  }
  public OAuthAuthorizeTokenBuilder(Boolean validationEnabled) {
    this(new OAuthAuthorizeToken(), validationEnabled);
  }
  public OAuthAuthorizeTokenBuilder(OAuthAuthorizeTokenFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthAuthorizeTokenBuilder(io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuthAuthorizeToken(), validationEnabled);
  }
  public OAuthAuthorizeTokenBuilder(io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent<?> fluent,io.fabric8.openshift.api.model.OAuthAuthorizeToken instance) {
    this(fluent, instance, false);
  }
  public OAuthAuthorizeTokenBuilder(io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent<?> fluent,io.fabric8.openshift.api.model.OAuthAuthorizeToken instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withClientName(instance.getClientName()); 
    fluent.withCodeChallenge(instance.getCodeChallenge()); 
    fluent.withCodeChallengeMethod(instance.getCodeChallengeMethod()); 
    fluent.withExpiresIn(instance.getExpiresIn()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withRedirectURI(instance.getRedirectURI()); 
    fluent.withScopes(instance.getScopes()); 
    fluent.withState(instance.getState()); 
    fluent.withUserName(instance.getUserName()); 
    fluent.withUserUID(instance.getUserUID()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthAuthorizeTokenBuilder(io.fabric8.openshift.api.model.OAuthAuthorizeToken instance) {
    this(instance,false);
  }
  public OAuthAuthorizeTokenBuilder(io.fabric8.openshift.api.model.OAuthAuthorizeToken instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withClientName(instance.getClientName()); 
    this.withCodeChallenge(instance.getCodeChallenge()); 
    this.withCodeChallengeMethod(instance.getCodeChallengeMethod()); 
    this.withExpiresIn(instance.getExpiresIn()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRedirectURI(instance.getRedirectURI()); 
    this.withScopes(instance.getScopes()); 
    this.withState(instance.getState()); 
    this.withUserName(instance.getUserName()); 
    this.withUserUID(instance.getUserUID()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuthAuthorizeToken build() {
    OAuthAuthorizeToken buildable = new OAuthAuthorizeToken(fluent.getApiVersion(),fluent.getClientName(),fluent.getCodeChallenge(),fluent.getCodeChallengeMethod(),fluent.getExpiresIn(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURI(),fluent.getScopes(),fluent.getState(),fluent.getUserName(),fluent.getUserUID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}