package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OAuthAccessTokenListBuilder extends OAuthAccessTokenListFluentImpl<OAuthAccessTokenListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.OAuthAccessTokenList,OAuthAccessTokenListBuilder>{
  public OAuthAccessTokenListBuilder() {
    this(false);
  }
  public OAuthAccessTokenListBuilder(Boolean validationEnabled) {
    this(new OAuthAccessTokenList(), validationEnabled);
  }
  public OAuthAccessTokenListBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenListFluent<?> fluent) {
    this(fluent, false);
  }
  public OAuthAccessTokenListBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OAuthAccessTokenList(), validationEnabled);
  }
  public OAuthAccessTokenListBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenListFluent<?> fluent,io.fabric8.openshift.api.model.OAuthAccessTokenList instance) {
    this(fluent, instance, false);
  }
  public OAuthAccessTokenListBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenListFluent<?> fluent,io.fabric8.openshift.api.model.OAuthAccessTokenList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OAuthAccessTokenListBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenList instance) {
    this(instance,false);
  }
  public OAuthAccessTokenListBuilder(io.fabric8.openshift.api.model.OAuthAccessTokenList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.OAuthAccessTokenListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.OAuthAccessTokenList build() {
    OAuthAccessTokenList buildable = new OAuthAccessTokenList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}