package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkSpecBuilder extends NetworkSpecFluentImpl<NetworkSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.NetworkSpec,io.fabric8.openshift.api.model.NetworkSpecBuilder>{
  public NetworkSpecBuilder() {
    this(false);
  }
  public NetworkSpecBuilder(Boolean validationEnabled) {
    this(new NetworkSpec(), validationEnabled);
  }
  public NetworkSpecBuilder(NetworkSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkSpec(), validationEnabled);
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpecFluent<?> fluent,io.fabric8.openshift.api.model.NetworkSpec instance) {
    this(fluent, instance, false);
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpecFluent<?> fluent,io.fabric8.openshift.api.model.NetworkSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterNetwork(instance.getClusterNetwork()); 
    fluent.withExternalIP(instance.getExternalIP()); 
    fluent.withNetworkType(instance.getNetworkType()); 
    fluent.withServiceNetwork(instance.getServiceNetwork()); 
    fluent.withServiceNodePortRange(instance.getServiceNodePortRange()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpec instance) {
    this(instance,false);
  }
  public NetworkSpecBuilder(io.fabric8.openshift.api.model.NetworkSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterNetwork(instance.getClusterNetwork()); 
    this.withExternalIP(instance.getExternalIP()); 
    this.withNetworkType(instance.getNetworkType()); 
    this.withServiceNetwork(instance.getServiceNetwork()); 
    this.withServiceNodePortRange(instance.getServiceNodePortRange()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.NetworkSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.NetworkSpec build() {
    NetworkSpec buildable = new NetworkSpec(fluent.getClusterNetwork(),fluent.getExternalIP(),fluent.getNetworkType(),fluent.getServiceNetwork(),fluent.getServiceNodePortRange());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}