package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkBuilder extends NetworkFluentImpl<NetworkBuilder> implements VisitableBuilder<Network,io.fabric8.openshift.api.model.NetworkBuilder>{
  public NetworkBuilder() {
    this(false);
  }
  public NetworkBuilder(Boolean validationEnabled) {
    this(new Network(), validationEnabled);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.NetworkFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.NetworkFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Network(), validationEnabled);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.NetworkFluent<?> fluent,io.fabric8.openshift.api.model.Network instance) {
    this(fluent, instance, false);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.NetworkFluent<?> fluent,io.fabric8.openshift.api.model.Network instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.Network instance) {
    this(instance,false);
  }
  public NetworkBuilder(io.fabric8.openshift.api.model.Network instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.NetworkFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Network build() {
    Network buildable = new Network(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}